/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.data.BatchIterator;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.exceptions.Exceptions;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.InputRow;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class LuceneBatchIterator
implements BatchIterator<Row> {
    private final IndexSearcher indexSearcher;
    private final Query query;
    private final CollectorContext collectorContext;
    private final boolean doScores;
    private final LuceneCollectorExpression[] expressions;
    private final List<LeafReaderContext> leaves;
    private final InputRow row;
    private Weight weight;
    private final Float minScore;
    private Iterator<LeafReaderContext> leavesIt;
    private LeafReaderContext currentLeaf;
    private Scorer currentScorer;
    private DocIdSetIterator currentDocIdSetIt;
    private volatile Throwable killed;

    public LuceneBatchIterator(IndexSearcher indexSearcher, Query query, @Nullable Float minScore, boolean doScores, CollectorContext collectorContext, List<? extends Input<?>> inputs, Collection<? extends LuceneCollectorExpression<?>> expressions) {
        this.indexSearcher = indexSearcher;
        this.query = query;
        this.doScores = doScores || minScore != null;
        this.minScore = minScore;
        this.collectorContext = collectorContext;
        this.row = new InputRow(inputs);
        this.expressions = expressions.toArray(new LuceneCollectorExpression[0]);
        this.leaves = indexSearcher.getTopReaderContext().leaves();
        this.leavesIt = this.leaves.iterator();
    }

    @Override
    public Row currentElement() {
        return this.row;
    }

    @Override
    public void moveToStart() {
        this.raiseIfKilled();
        this.leavesIt = this.leaves.iterator();
    }

    @Override
    public boolean moveNext() {
        this.raiseIfKilled();
        if (this.weight == null) {
            try {
                this.weight = this.createWeight();
            }
            catch (IOException e) {
                Exceptions.rethrowUnchecked(e);
            }
        }
        try {
            return this.innerMoveNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean innerMoveNext() throws IOException {
        while (this.tryAdvanceDocIdSetIterator()) {
            int doc;
            LeafReader reader = this.currentLeaf.reader();
            Bits liveDocs = reader.getLiveDocs();
            while ((doc = this.currentDocIdSetIt.nextDoc()) != Integer.MAX_VALUE) {
                if (LuceneBatchIterator.docDeleted(liveDocs, doc) || this.belowMinScore(this.currentScorer)) continue;
                this.onDoc(doc);
                return true;
            }
            this.currentDocIdSetIt = null;
        }
        this.clearState();
        return false;
    }

    private boolean belowMinScore(Scorer currentScorer) throws IOException {
        return this.minScore != null && currentScorer.score() < this.minScore.floatValue();
    }

    private boolean tryAdvanceDocIdSetIterator() throws IOException {
        if (this.currentDocIdSetIt != null) {
            return true;
        }
        while (this.leavesIt.hasNext()) {
            LeafReaderContext leaf = this.leavesIt.next();
            Scorer scorer = this.weight.scorer(leaf);
            if (scorer == null) continue;
            this.currentScorer = scorer;
            this.currentLeaf = leaf;
            this.currentDocIdSetIt = scorer.iterator();
            ReaderContext readerContext = new ReaderContext(this.currentLeaf);
            for (LuceneCollectorExpression expression : this.expressions) {
                expression.setScorer((Scorable)this.currentScorer);
                expression.setNextReader(readerContext);
            }
            return true;
        }
        return false;
    }

    private void clearState() {
        this.currentDocIdSetIt = null;
        this.currentScorer = null;
        this.currentLeaf = null;
    }

    @Override
    public void close() {
        this.clearState();
        this.killed = BatchIterator.CLOSED;
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        throw new IllegalStateException("BatchIterator already fully loaded");
    }

    private Weight createWeight() throws IOException {
        for (LuceneCollectorExpression expression : this.expressions) {
            expression.startCollect(this.collectorContext);
        }
        ScoreMode scoreMode = this.doScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        return this.indexSearcher.createWeight(this.indexSearcher.rewrite(this.query), scoreMode, 1.0f);
    }

    @Override
    public boolean allLoaded() {
        return true;
    }

    @Override
    public boolean hasLazyResultSet() {
        return true;
    }

    private static boolean docDeleted(@Nullable Bits liveDocs, int doc) {
        if (liveDocs == null) {
            return false;
        }
        return !liveDocs.get(doc);
    }

    private void onDoc(int doc) throws IOException {
        for (LuceneCollectorExpression expression : this.expressions) {
            expression.setNextDocId(doc);
        }
    }

    private void raiseIfKilled() {
        if (this.killed != null) {
            Exceptions.rethrowUnchecked(this.killed);
        }
    }

    @Override
    public void kill(@Nonnull Throwable throwable) {
        this.killed = throwable;
    }
}

