/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.analyze.WhereClause;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.pipeline.ProjectionToProjectorVisitor;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.Projectors;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Schemas;
import io.crate.metadata.shard.ShardReferenceResolver;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ShardCollectorProvider {
    private final ProjectorFactory projectorFactory;
    private final ShardRowContext shardRowContext;
    protected final IndexShard indexShard;
    final EvaluatingNormalizer shardNormalizer;

    ShardCollectorProvider(ClusterService clusterService, CircuitBreakerService circuitBreakerService, Schemas schemas, NodeJobsCounter nodeJobsCounter, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, TransportActionProvider transportActionProvider, IndexShard indexShard, ShardRowContext shardRowContext) {
        this.indexShard = indexShard;
        this.shardRowContext = shardRowContext;
        this.shardNormalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.SHARD, new ShardReferenceResolver(schemas, shardRowContext), null);
        this.projectorFactory = new ProjectionToProjectorVisitor(clusterService, nodeJobsCounter, circuitBreakerService, nodeCtx, threadPool, settings, transportActionProvider, new InputFactory(nodeCtx), this.shardNormalizer, t -> null, t -> null, indexShard.indexSettings().getIndexVersionCreated(), indexShard.shardId());
    }

    public ShardRowContext shardRowContext() {
        return this.shardRowContext;
    }

    public CompletableFuture<BatchIterator<Row>> getFutureIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) throws Exception {
        CompletableFuture<BatchIterator<Row>> futureIt = new CompletableFuture<BatchIterator<Row>>();
        this.indexShard.awaitShardSearchActive(b -> {
            try {
                futureIt.complete(this.getIterator(collectPhase, requiresScroll, collectTask));
            }
            catch (Throwable t) {
                futureIt.completeExceptionally(t);
            }
        });
        return futureIt;
    }

    private BatchIterator<Row> getIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) throws Exception {
        BatchIterator<Row> fusedIterator;
        assert (collectPhase.orderBy() == null) : "getDocCollector shouldn't be called if there is an orderBy on the collectPhase";
        assert (collectPhase.maxRowGranularity() == RowGranularity.DOC) : "granularity must be DOC";
        boolean isOpenIndex = this.indexShard.mapperService() != null;
        RoutedCollectPhase normalizedCollectNode = collectPhase.normalize(this.shardNormalizer, collectTask.txnCtx());
        if (isOpenIndex && (fusedIterator = this.getProjectionFusedIterator(normalizedCollectNode, collectTask)) != null) {
            return fusedIterator;
        }
        BatchIterator<Row> iterator = isOpenIndex && WhereClause.canMatch(normalizedCollectNode.where()) ? this.getUnorderedIterator(normalizedCollectNode, requiresScroll, collectTask) : InMemoryBatchIterator.empty(SentinelRow.SENTINEL);
        return Projectors.wrap(Projections.shardProjections(collectPhase.projections()), collectPhase.jobId(), collectTask.txnCtx(), collectTask.getRamAccounting(), collectTask.memoryManager(), this.projectorFactory, iterator);
    }

    @Nullable
    protected abstract BatchIterator<Row> getProjectionFusedIterator(RoutedCollectPhase var1, CollectTask var2);

    protected abstract BatchIterator<Row> getUnorderedIterator(RoutedCollectPhase var1, boolean var2, CollectTask var3);

    public final CompletableFuture<OrderedDocCollector> getFutureOrderedCollector(RoutedCollectPhase collectPhase, SharedShardContext sharedShardContext, CollectTask collectTask, boolean requiresRepeat) {
        CompletableFuture<OrderedDocCollector> futureIt = new CompletableFuture<OrderedDocCollector>();
        this.indexShard.awaitShardSearchActive(b -> {
            try {
                futureIt.complete(this.getOrderedCollector(collectPhase, sharedShardContext, collectTask, requiresRepeat));
            }
            catch (Throwable t) {
                futureIt.completeExceptionally(t);
            }
        });
        return futureIt;
    }

    protected abstract OrderedDocCollector getOrderedCollector(RoutedCollectPhase var1, SharedShardContext var2, CollectTask var3, boolean var4);

    public ProjectorFactory getProjectorFactory() {
        return this.projectorFactory;
    }
}

