/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.analyze.Id;
import io.crate.common.StringUtils;
import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RowShardResolver {
    private final Function<List<String>, String> idFunction;
    private final List<Input<?>> primaryKeyInputs;
    private final Input<?> routingInput;
    private final Iterable<CollectExpression<Row, ?>> expressions;
    private String id;
    private String routing;

    public RowShardResolver(TransactionContext txnCtx, NodeContext nodeCtx, List<ColumnIdent> pkColumns, List<? extends Symbol> primaryKeySymbols, @Nullable ColumnIdent clusteredByColumn, @Nullable Symbol routingSymbol) {
        InputFactory inputFactory = new InputFactory(nodeCtx);
        InputFactory.Context<CollectExpression<Row, ?>> context = inputFactory.ctxForInputColumns(txnCtx);
        this.idFunction = Id.compileWithNullValidation(pkColumns, clusteredByColumn);
        this.routingInput = routingSymbol == null ? null : context.add(routingSymbol);
        this.primaryKeyInputs = new ArrayList(primaryKeySymbols.size());
        for (Symbol symbol : primaryKeySymbols) {
            this.primaryKeyInputs.add(context.add(symbol));
        }
        this.expressions = context.expressions();
    }

    public void setNextRow(Row row) {
        for (CollectExpression<Row, ?> expression : this.expressions) {
            expression.setNextRow(row);
        }
        this.id = this.idFunction.apply(RowShardResolver.pkValues(this.primaryKeyInputs));
        this.routing = this.routingInput == null ? null : StringUtils.nullOrString(this.routingInput.value());
    }

    private static List<String> pkValues(List<Input<?>> primaryKeyInputs) {
        return Lists2.map(primaryKeyInputs, input -> StringUtils.nullOrString(input.value()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }
}

