/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.common.collections.Lists2;
import io.crate.data.BatchIterator;
import io.crate.data.Buckets;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.CollectingRowConsumer;
import io.crate.data.Row;
import io.crate.exceptions.Exceptions;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.RemoteCollector;
import io.crate.execution.engine.collect.collectors.ShardStateObserver;
import io.crate.execution.engine.collect.sources.ShardCollectorProviderFactory;
import io.crate.execution.jobs.TasksService;
import io.crate.metadata.Routing;
import io.crate.planner.distribution.DistributionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class RemoteCollectorFactory {
    private static final int SENDER_PHASE_ID = 0;
    private final ClusterService clusterService;
    private final TasksService tasksService;
    private final TransportActionProvider transportActionProvider;
    private final IndicesService indicesService;
    private final Executor searchTp;

    @Inject
    public RemoteCollectorFactory(ClusterService clusterService, TasksService tasksService, TransportActionProvider transportActionProvider, IndicesService indicesService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.tasksService = tasksService;
        this.transportActionProvider = transportActionProvider;
        this.indicesService = indicesService;
        this.searchTp = threadPool.executor("search");
    }

    public CompletableFuture<BatchIterator<Row>> createCollector(ShardId shardId, RoutedCollectPhase collectPhase, CollectTask collectTask, ShardCollectorProviderFactory shardCollectorProviderFactory) {
        ShardStateObserver shardStateObserver = new ShardStateObserver(this.clusterService);
        CompletableFuture<ShardRouting> shardBecameActive = shardStateObserver.waitForActiveShard(shardId);
        Runnable onClose = () -> {};
        Consumer<Throwable> kill = killReason -> {
            shardBecameActive.cancel(true);
            shardBecameActive.completeExceptionally((Throwable)killReason);
        };
        return shardBecameActive.thenApply(activePrimaryRouting -> CollectingBatchIterator.newInstance(onClose, kill, () -> this.retrieveRows((ShardRouting)activePrimaryRouting, collectPhase, collectTask, shardCollectorProviderFactory), true));
    }

    private CompletableFuture<List<Row>> retrieveRows(ShardRouting activePrimaryRouting, RoutedCollectPhase collectPhase, CollectTask collectTask, ShardCollectorProviderFactory shardCollectorProviderFactory) {
        Collector listCollector = Collectors.mapping(Row::materialize, Collectors.toList());
        CollectingRowConsumer consumer = new CollectingRowConsumer(listCollector);
        String nodeId = activePrimaryRouting.currentNodeId();
        String localNodeId = this.clusterService.localNode().getId();
        if (localNodeId.equalsIgnoreCase(nodeId)) {
            CompletableFuture<BatchIterator<Row>> it;
            IndexShard indexShard = this.indicesService.indexServiceSafe(activePrimaryRouting.index()).getShard(activePrimaryRouting.shardId().id());
            ShardCollectorProvider collectorProvider = shardCollectorProviderFactory.create(indexShard);
            try {
                it = collectorProvider.getFutureIterator(collectPhase, consumer.requiresScroll(), collectTask);
            }
            catch (Exception e) {
                return (CompletableFuture)Exceptions.rethrowRuntimeException(e);
            }
            it.whenComplete((BiConsumer)consumer);
        } else {
            UUID childJobId = UUID.randomUUID();
            RemoteCollector remoteCollector = new RemoteCollector(childJobId, collectTask.txnCtx().sessionSettings(), localNodeId, nodeId, this.transportActionProvider.transportJobInitAction(), this.transportActionProvider.transportKillJobsNodeAction(), this.searchTp, this.tasksService, collectTask.getRamAccounting(), consumer, RemoteCollectorFactory.createRemoteCollectPhase(childJobId, collectPhase, activePrimaryRouting.shardId(), nodeId));
            remoteCollector.doCollect();
        }
        return consumer.completionFuture().thenApply(rows -> Lists2.mapLazy(rows, Buckets.arrayToSharedRow()));
    }

    private static RoutedCollectPhase createRemoteCollectPhase(UUID childJobId, RoutedCollectPhase collectPhase, ShardId shardId, String nodeId) {
        Routing routing = new Routing(Map.of(nodeId, Map.of(shardId.getIndexName(), IntArrayList.from((int[])new int[]{shardId.getId()}))));
        return new RoutedCollectPhase(childJobId, 0, collectPhase.name(), routing, collectPhase.maxRowGranularity(), collectPhase.toCollect(), new ArrayList<Projection>(Projections.shardProjections(collectPhase.projections())), collectPhase.where(), DistributionInfo.DEFAULT_BROADCAST);
    }
}

