/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.execution.engine.collect.sources.CollectSourceResolver;
import io.crate.metadata.TransactionContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class MapSideDataCollectOperation {
    private final CollectSourceResolver collectSourceResolver;
    private final ThreadPool threadPool;

    @Inject
    public MapSideDataCollectOperation(CollectSourceResolver collectSourceResolver, ThreadPool threadPool) {
        this.collectSourceResolver = collectSourceResolver;
        this.threadPool = threadPool;
    }

    public CompletableFuture<BatchIterator<Row>> createIterator(TransactionContext txnCtx, CollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) {
        CollectSource service = this.collectSourceResolver.getService(collectPhase);
        return service.getIterator(txnCtx, collectPhase, collectTask, requiresScroll);
    }

    public void launch(Runnable runnable, String threadPoolName) throws RejectedExecutionException {
        Executor executor = this.threadPool.executor(threadPoolName);
        executor.execute(runnable);
    }
}

