/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.common.collections.RefCountedItem;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.collect.DocValuesAggregates;
import io.crate.execution.engine.collect.DocValuesGroupByOptimizedIterator;
import io.crate.execution.engine.collect.GroupByOptimizedIterator;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.LuceneBatchIterator;
import io.crate.execution.engine.collect.collectors.LuceneOrderedDocCollector;
import io.crate.execution.engine.collect.collectors.OptimizeQueryForSearchAfter;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.sort.LuceneSortGenerator;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.FieldTypeLookup;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;

public class LuceneShardCollectorProvider
extends ShardCollectorProvider {
    private static final Logger LOGGER = LogManager.getLogger(LuceneShardCollectorProvider.class);
    private final Supplier<String> localNodeId;
    private final LuceneQueryBuilder luceneQueryBuilder;
    private final NodeContext nodeCtx;
    private final IndexShard indexShard;
    private final DocInputFactory docInputFactory;
    private final BigArrays bigArrays;
    private final FieldTypeLookup fieldTypeLookup;
    private final DocTableInfo table;

    public LuceneShardCollectorProvider(Schemas schemas, LuceneQueryBuilder luceneQueryBuilder, ClusterService clusterService, NodeJobsCounter nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, TransportActionProvider transportActionProvider, IndexShard indexShard, BigArrays bigArrays) {
        super(clusterService, circuitBreakerService, schemas, nodeJobsCounter, nodeCtx, threadPool, settings, transportActionProvider, indexShard, new ShardRowContext(indexShard, clusterService));
        this.luceneQueryBuilder = luceneQueryBuilder;
        this.nodeCtx = nodeCtx;
        this.indexShard = indexShard;
        this.localNodeId = () -> clusterService.localNode().getId();
        MapperService mapperService = indexShard.mapperService();
        this.fieldTypeLookup = mapperService == null ? name -> null : mapperService::fullName;
        RelationName relationName = RelationName.fromIndexName(indexShard.shardId().getIndexName());
        this.table = (DocTableInfo)schemas.getTableInfo(relationName, Operation.READ);
        this.docInputFactory = new DocInputFactory(nodeCtx, new LuceneReferenceResolver(indexShard.shardId().getIndexName(), this.fieldTypeLookup, this.table.partitionedByColumns()));
        this.bigArrays = bigArrays;
    }

    @Override
    protected BatchIterator<Row> getUnorderedIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) {
        ShardId shardId = this.indexShard.shardId();
        SharedShardContext sharedShardContext = collectTask.sharedShardContexts().getOrCreateContext(shardId);
        RefCountedItem<? extends IndexSearcher> searcher = sharedShardContext.acquireSearcher("unordered-iterator: " + LuceneShardCollectorProvider.formatSource(collectPhase));
        collectTask.addSearcher(sharedShardContext.readerId(), searcher);
        IndexShard indexShard = sharedShardContext.indexShard();
        QueryShardContext queryShardContext = sharedShardContext.indexService().newQueryShardContext();
        LuceneQueryBuilder.Context queryContext = this.luceneQueryBuilder.convert(collectPhase.where(), collectTask.txnCtx(), indexShard.mapperService(), indexShard.shardId().getIndexName(), queryShardContext, this.table, sharedShardContext.indexService().cache());
        InputFactory.Context<LuceneCollectorExpression<?>> docCtx = this.docInputFactory.extractImplementations(collectTask.txnCtx(), collectPhase);
        return new LuceneBatchIterator(searcher.item(), queryContext.query(), queryContext.minScore(), Symbols.containsColumn(collectPhase.toCollect(), DocSysColumns.SCORE), new CollectorContext(sharedShardContext.readerId()), docCtx.topLevelInputs(), docCtx.expressions());
    }

    @Override
    @Nullable
    protected BatchIterator<Row> getProjectionFusedIterator(RoutedCollectPhase normalizedPhase, CollectTask collectTask) {
        BatchIterator<Row> it = GroupByOptimizedIterator.tryOptimizeSingleStringKey(this.indexShard, this.table, this.luceneQueryBuilder, this.fieldTypeLookup, this.bigArrays, new InputFactory(this.nodeCtx), this.docInputFactory, normalizedPhase, collectTask);
        if (it != null) {
            return it;
        }
        it = DocValuesGroupByOptimizedIterator.tryOptimize(this.nodeCtx.functions(), this.indexShard, this.table, this.luceneQueryBuilder, this.fieldTypeLookup, this.docInputFactory, normalizedPhase, collectTask);
        if (it != null) {
            return it;
        }
        return DocValuesAggregates.tryOptimize(this.nodeCtx.functions(), this.indexShard, this.table, this.luceneQueryBuilder, this.fieldTypeLookup, normalizedPhase, collectTask);
    }

    @Override
    public OrderedDocCollector getOrderedCollector(RoutedCollectPhase phase, SharedShardContext sharedShardContext, CollectTask collectTask, boolean requiresRepeat) {
        RoutedCollectPhase collectPhase = phase.normalize(this.shardNormalizer, collectTask.txnCtx());
        RefCountedItem<? extends IndexSearcher> searcher = sharedShardContext.acquireSearcher("ordered-collector: " + LuceneShardCollectorProvider.formatSource(phase));
        collectTask.addSearcher(sharedShardContext.readerId(), searcher);
        IndexService indexService = sharedShardContext.indexService();
        QueryShardContext queryShardContext = indexService.newQueryShardContext();
        LuceneQueryBuilder.Context queryContext = this.luceneQueryBuilder.convert(collectPhase.where(), collectTask.txnCtx(), indexService.mapperService(), this.indexShard.shardId().getIndexName(), queryShardContext, this.table, indexService.cache());
        InputFactory.Context<LuceneCollectorExpression<?>> ctx = this.docInputFactory.extractImplementations(collectTask.txnCtx(), collectPhase);
        CollectorContext collectorContext = new CollectorContext(sharedShardContext.readerId());
        int batchSize = collectPhase.shardQueueSize(this.localNodeId.get());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[{}][{}] creating LuceneOrderedDocCollector. Expected number of rows to be collected: {}", (Object)sharedShardContext.indexShard().routingEntry().currentNodeId(), (Object)sharedShardContext.indexShard().shardId(), (Object)batchSize);
        }
        OptimizeQueryForSearchAfter optimizeQueryForSearchAfter = new OptimizeQueryForSearchAfter(collectPhase.orderBy(), queryContext.queryShardContext(), this.fieldTypeLookup);
        return new LuceneOrderedDocCollector(this.indexShard.shardId(), searcher.item(), queryContext.query(), queryContext.minScore(), Symbols.containsColumn(collectPhase.toCollect(), DocSysColumns.SCORE), batchSize, collectTask.getRamAccounting(), collectorContext, optimizeQueryForSearchAfter, LuceneSortGenerator.generateLuceneSort(collectTask.txnCtx(), collectorContext, collectPhase.orderBy(), this.docInputFactory, this.fieldTypeLookup), ctx.topLevelInputs(), ctx.expressions());
    }

    static String formatSource(RoutedCollectPhase phase) {
        return phase.jobId().toString() + "-" + phase.phaseId() + "-" + phase.name();
    }
}

