/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;

public class InputCollectExpression
implements CollectExpression<Row, Object> {
    private final int position;
    private Object value;

    public InputCollectExpression(int position) {
        this.position = position;
    }

    @Override
    public void setNextRow(Row row) {
        assert (row.numColumns() > this.position) : "Wanted to retrieve value for column at position=" + this.position + " from row=" + row + " but row has only " + row.numColumns() + " columns";
        this.value = row.get(this.position);
    }

    @Override
    public Object value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputCollectExpression that = (InputCollectExpression)o;
        if (this.position != that.position) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.position;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Input{pos=" + this.position + "}";
    }
}

