/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.breaker.MultiSizeEstimator;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.RefCountedItem;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.exceptions.Exceptions;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.GroupByMaps;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.collect.DocValuesAggregates;
import io.crate.execution.engine.collect.LuceneShardCollectorProvider;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.FieldTypeLookup;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

final class DocValuesGroupByOptimizedIterator {
    DocValuesGroupByOptimizedIterator() {
    }

    @Nullable
    static BatchIterator<Row> tryOptimize(Functions functions, IndexShard indexShard, DocTableInfo table, LuceneQueryBuilder luceneQueryBuilder, FieldTypeLookup fieldTypeLookup, DocInputFactory docInputFactory, RoutedCollectPhase collectPhase, CollectTask collectTask) {
        if (Symbols.containsColumn(collectPhase.toCollect(), DocSysColumns.SCORE) || Symbols.containsColumn(collectPhase.where(), DocSysColumns.SCORE)) {
            return null;
        }
        Collection<? extends Projection> shardProjections = Projections.shardProjections(collectPhase.projections());
        GroupProjection groupProjection = DocValuesGroupByOptimizedIterator.getSinglePartialGroupProjection(shardProjections);
        if (groupProjection == null) {
            return null;
        }
        ArrayList<Reference> columnKeyRefs = new ArrayList<Reference>(groupProjection.keys().size());
        for (Symbol key : groupProjection.keys()) {
            Reference docKeyRef = DocValuesGroupByOptimizedIterator.getKeyRef(collectPhase.toCollect(), key);
            if (docKeyRef == null) {
                return null;
            }
            Reference columnKeyRef = (Reference)DocReferences.inverseSourceLookup(docKeyRef);
            MappedFieldType keyFieldType = fieldTypeLookup.get(columnKeyRef.column().fqn());
            if (keyFieldType == null || !keyFieldType.hasDocValues()) {
                return null;
            }
            columnKeyRefs.add(columnKeyRef);
        }
        List<DocValueAggregator> aggregators = DocValuesAggregates.createAggregators(functions, groupProjection.values(), fieldTypeLookup, collectPhase.toCollect(), collectTask.txnCtx().sessionSettings().searchPath());
        if (aggregators == null) {
            return null;
        }
        ShardId shardId = indexShard.shardId();
        SharedShardContext sharedShardContext = collectTask.sharedShardContexts().getOrCreateContext(shardId);
        RefCountedItem<? extends IndexSearcher> searcher = sharedShardContext.acquireSearcher("group-by-doc-value-aggregates: " + LuceneShardCollectorProvider.formatSource(collectPhase));
        collectTask.addSearcher(sharedShardContext.readerId(), searcher);
        QueryShardContext queryShardContext = sharedShardContext.indexService().newQueryShardContext();
        InputFactory.Context<LuceneCollectorExpression<?>> docCtx = docInputFactory.getCtx(collectTask.txnCtx());
        docCtx.add(columnKeyRefs);
        List<? extends LuceneCollectorExpression<?>> keyExpressions = docCtx.expressions();
        LuceneQueryBuilder.Context queryContext = luceneQueryBuilder.convert(collectPhase.where(), collectTask.txnCtx(), indexShard.mapperService(), indexShard.shardId().getIndexName(), queryShardContext, table, sharedShardContext.indexService().cache());
        RamAccounting ramAccounting = collectTask.getRamAccounting();
        if (columnKeyRefs.size() == 1) {
            return GroupByIterator.forSingleKey(aggregators, searcher.item(), (Reference)columnKeyRefs.get(0), keyExpressions, ramAccounting, queryContext.query(), new CollectorContext(sharedShardContext.readerId()));
        }
        return GroupByIterator.forManyKeys(aggregators, searcher.item(), columnKeyRefs, keyExpressions, ramAccounting, queryContext.query(), new CollectorContext(sharedShardContext.readerId()));
    }

    @Nullable
    private static Reference getKeyRef(List<Symbol> toCollect, Symbol key) {
        Symbol keyRef;
        if (key instanceof InputColumn && (keyRef = toCollect.get(((InputColumn)key).index())) instanceof Reference) {
            return (Reference)keyRef;
        }
        return null;
    }

    private static GroupProjection getSinglePartialGroupProjection(Collection<? extends Projection> shardProjections) {
        if (shardProjections.size() != 1) {
            return null;
        }
        Projection shardProjection = shardProjections.iterator().next();
        if (!(shardProjection instanceof GroupProjection) || ((GroupProjection)shardProjection).mode() == AggregateMode.ITER_FINAL) {
            return null;
        }
        return (GroupProjection)shardProjection;
    }

    static class GroupByIterator {
        GroupByIterator() {
        }

        @VisibleForTesting
        static BatchIterator<Row> forSingleKey(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, Reference keyReference, List<? extends LuceneCollectorExpression<?>> keyExpressions, RamAccounting ramAccounting, Query query, CollectorContext collectorContext) {
            return GroupByIterator.getIterator(aggregators, indexSearcher, keyExpressions, ramAccounting, GroupByMaps.accountForNewEntry(ramAccounting, SizeEstimatorFactory.create(keyReference.valueType()), null), expressions -> ((LuceneCollectorExpression)expressions.get(0)).value(), (key, cells) -> {
                cells[0] = key;
            }, query, new CollectorContext(collectorContext.readerId()));
        }

        @VisibleForTesting
        static <K> BatchIterator<Row> forManyKeys(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, List<Reference> keyColumnRefs, List<? extends LuceneCollectorExpression<?>> keyExpressions, RamAccounting ramAccounting, Query query, CollectorContext collectorContext) {
            return GroupByIterator.getIterator(aggregators, indexSearcher, keyExpressions, ramAccounting, GroupByMaps.accountForNewEntry(ramAccounting, new MultiSizeEstimator(Lists2.map(keyColumnRefs, Reference::valueType)), null), expressions -> {
                ArrayList key = new ArrayList(keyColumnRefs.size());
                for (int i = 0; i < expressions.size(); ++i) {
                    key.add(((LuceneCollectorExpression)expressions.get(i)).value());
                }
                return key;
            }, (keys, cells) -> {
                for (int i = 0; i < keys.size(); ++i) {
                    cells[i] = keys.get(i);
                }
            }, query, new CollectorContext(collectorContext.readerId()));
        }

        @VisibleForTesting
        static <K> BatchIterator<Row> getIterator(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, List<? extends LuceneCollectorExpression<?>> keyExpressions, RamAccounting ramAccounting, BiConsumer<Map<K, Object[]>, K> accountForNewKeyEntry, Function<List<? extends LuceneCollectorExpression<?>>, K> keyExtractor, BiConsumer<K, Object[]> applyKeyToCells, Query query, CollectorContext collectorContext) {
            for (int i = 0; i < keyExpressions.size(); ++i) {
                keyExpressions.get(i).startCollect(collectorContext);
            }
            AtomicReference killed = new AtomicReference();
            return CollectingBatchIterator.newInstance(() -> killed.set(BatchIterator.CLOSED), killed::set, () -> {
                try {
                    return CompletableFuture.completedFuture(GroupByIterator.getRows(GroupByIterator.applyAggregatesGroupedByKey(aggregators, indexSearcher, keyExpressions, accountForNewKeyEntry, keyExtractor, ramAccounting, query, killed), keyExpressions.size(), applyKeyToCells, aggregators, ramAccounting));
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
            }, true);
        }

        private static <K> Iterable<Row> getRows(Map<K, Object[]> groupedStates, final int numberOfKeys, final BiConsumer<K, Object[]> applyKeyToCells, final List<DocValueAggregator> aggregators, final RamAccounting ramAccounting) {
            return () -> groupedStates.entrySet().stream().map(new Function<Map.Entry<K, Object[]>, Row>(){
                Object[] cells;
                RowN row;
                {
                    this.cells = new Object[numberOfKeys + aggregators.size()];
                    this.row = new RowN(this.cells);
                }

                @Override
                public Row apply(Map.Entry<K, Object[]> entry) {
                    Object key = entry.getKey();
                    applyKeyToCells.accept(key, this.cells);
                    Object[] states = entry.getValue();
                    int c = numberOfKeys;
                    for (int i = 0; i < states.length; ++i) {
                        this.cells[c] = ((DocValueAggregator)aggregators.get(i)).partialResult(ramAccounting, states[i]);
                        ++c;
                    }
                    return this.row;
                }
            }).iterator();
        }

        private static <K> Map<K, Object[]> applyAggregatesGroupedByKey(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, List<? extends LuceneCollectorExpression<?>> keyExpressions, BiConsumer<Map<K, Object[]>, K> accountForNewKeyEntry, Function<List<? extends LuceneCollectorExpression<?>>, K> keyExtractor, RamAccounting ramAccounting, Query query, AtomicReference<Throwable> killed) throws IOException {
            HashMap<K, Object[]> statesByKey = new HashMap<K, Object[]>();
            Weight weight = indexSearcher.createWeight(indexSearcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            List leaves = indexSearcher.getTopReaderContext().leaves();
            for (LeafReaderContext leaf : leaves) {
                int i;
                GroupByIterator.raiseIfClosedOrKilled(killed);
                Scorer scorer = weight.scorer(leaf);
                if (scorer == null) continue;
                for (i = 0; i < keyExpressions.size(); ++i) {
                    keyExpressions.get(i).setNextReader(new ReaderContext(leaf));
                }
                for (i = 0; i < aggregators.size(); ++i) {
                    aggregators.get(i).loadDocValues(leaf.reader());
                }
                DocIdSetIterator docs = scorer.iterator();
                Bits liveDocs = leaf.reader().getLiveDocs();
                int doc = docs.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    GroupByIterator.raiseIfClosedOrKilled(killed);
                    if (!GroupByIterator.docDeleted(liveDocs, doc)) {
                        int i2;
                        for (int i3 = 0; i3 < keyExpressions.size(); ++i3) {
                            keyExpressions.get(i3).setNextDocId(doc);
                        }
                        K key = keyExtractor.apply(keyExpressions);
                        Object[] states = (Object[])statesByKey.get(key);
                        if (states == null) {
                            states = new Object[aggregators.size()];
                            for (i2 = 0; i2 < aggregators.size(); ++i2) {
                                DocValueAggregator aggregator = aggregators.get(i2);
                                states[i2] = aggregator.initialState(ramAccounting);
                                aggregator.apply(ramAccounting, doc, states[i2]);
                            }
                            accountForNewKeyEntry.accept(statesByKey, key);
                            statesByKey.put(key, states);
                        } else {
                            for (i2 = 0; i2 < aggregators.size(); ++i2) {
                                aggregators.get(i2).apply(ramAccounting, doc, states[i2]);
                            }
                        }
                    }
                    doc = docs.nextDoc();
                }
            }
            return statesByKey;
        }

        private static boolean docDeleted(@Nullable Bits liveDocs, int doc) {
            return liveDocs != null && !liveDocs.get(doc);
        }

        private static void raiseIfClosedOrKilled(AtomicReference<Throwable> killed) {
            Throwable killedException = killed.get();
            if (killedException != null) {
                Exceptions.rethrowUnchecked(killedException);
            }
        }
    }
}

