/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.breaker.RamAccounting;
import io.crate.common.collections.RefCountedItem;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.exceptions.Exceptions;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.AggregationProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.LuceneShardCollectorProvider;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.FieldTypeLookup;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

public class DocValuesAggregates {
    @Nullable
    public static BatchIterator<Row> tryOptimize(Functions functions, IndexShard indexShard, DocTableInfo table, LuceneQueryBuilder luceneQueryBuilder, FieldTypeLookup fieldTypeLookup, RoutedCollectPhase phase, CollectTask collectTask) {
        Collection<? extends Projection> shardProjections = Projections.shardProjections(phase.projections());
        AggregationProjection aggregateProjection = DocValuesAggregates.aggregateProjection(shardProjections);
        if (aggregateProjection == null) {
            return null;
        }
        List<DocValueAggregator> aggregators = DocValuesAggregates.createAggregators(functions, aggregateProjection, fieldTypeLookup, phase.toCollect(), collectTask.txnCtx().sessionSettings().searchPath());
        if (aggregators == null) {
            return null;
        }
        ShardId shardId = indexShard.shardId();
        SharedShardContext shardContext = collectTask.sharedShardContexts().getOrCreateContext(shardId);
        RefCountedItem<? extends IndexSearcher> searcher = shardContext.acquireSearcher("doc-value-aggregates: " + LuceneShardCollectorProvider.formatSource(phase));
        collectTask.addSearcher(shardContext.readerId(), searcher);
        QueryShardContext queryShardContext = shardContext.indexService().newQueryShardContext();
        LuceneQueryBuilder.Context queryContext = luceneQueryBuilder.convert(phase.where(), collectTask.txnCtx(), indexShard.mapperService(), indexShard.shardId().getIndexName(), queryShardContext, table, shardContext.indexService().cache());
        AtomicReference killed = new AtomicReference();
        return CollectingBatchIterator.newInstance(() -> killed.set(BatchIterator.CLOSED), killed::set, () -> {
            try {
                return CompletableFuture.completedFuture(DocValuesAggregates.getRow(collectTask.getRamAccounting(), killed, (IndexSearcher)searcher.item(), queryContext.query(), aggregators));
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        }, true);
    }

    @Nullable
    private static List<DocValueAggregator> createAggregators(Functions functions, AggregationProjection aggregateProjection, FieldTypeLookup fieldTypeLookup, List<Symbol> toCollect, SearchPath searchPath) {
        return DocValuesAggregates.createAggregators(functions, aggregateProjection.aggregations(), fieldTypeLookup, toCollect, searchPath);
    }

    @Nullable
    public static List<DocValueAggregator> createAggregators(Functions functions, List<Aggregation> aggregations, FieldTypeLookup fieldTypeLookup, List<Symbol> toCollect, SearchPath searchPath) {
        ArrayList<DocValueAggregator> aggregator = new ArrayList<DocValueAggregator>(aggregations.size());
        for (int i = 0; i < aggregations.size(); ++i) {
            Aggregation aggregation = aggregations.get(i);
            if (!aggregation.filter().equals(Literal.BOOLEAN_TRUE)) {
                return null;
            }
            ArrayList<Symbol> aggregationReferences = new ArrayList<Symbol>(aggregation.inputs().size());
            for (Symbol symbol : aggregation.inputs()) {
                Symbol reference = symbol.accept(AggregationInputToReferenceResolver.INSTANCE, toCollect);
                if (reference == null) {
                    return null;
                }
                aggregationReferences.add(reference);
            }
            ArrayList<MappedFieldType> fieldTypes = new ArrayList<MappedFieldType>(aggregationReferences.size());
            for (Symbol reference : aggregationReferences) {
                MappedFieldType mappedFieldType = fieldTypeLookup.get(((Reference)reference).column().fqn());
                if (mappedFieldType == null || !mappedFieldType.hasDocValues()) {
                    return null;
                }
                fieldTypes.add(mappedFieldType);
            }
            FunctionImplementation functionImplementation = functions.getQualified(aggregation, searchPath);
            if (!(functionImplementation instanceof AggregationFunction)) {
                throw new IllegalStateException("Expected an aggregationFunction for " + aggregation + " got: " + functionImplementation);
            }
            DocValueAggregator<?> docValueAggregator = ((AggregationFunction)functionImplementation).getDocValueAggregator(Symbols.typeView(aggregationReferences), fieldTypes);
            if (docValueAggregator == null) {
                return null;
            }
            aggregator.add(docValueAggregator);
        }
        return aggregator;
    }

    private static Iterable<Row> getRow(RamAccounting ramAccounting, AtomicReference<Throwable> killed, IndexSearcher searcher, Query query, List<DocValueAggregator> aggregators) throws IOException {
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        List leaves = searcher.getTopReaderContext().leaves();
        Object[] cells = new Object[aggregators.size()];
        for (int i = 0; i < aggregators.size(); ++i) {
            cells[i] = aggregators.get(i).initialState(ramAccounting);
        }
        for (LeafReaderContext leaf : leaves) {
            Scorer scorer = weight.scorer(leaf);
            if (scorer == null) continue;
            for (int i = 0; i < aggregators.size(); ++i) {
                aggregators.get(i).loadDocValues(leaf.reader());
            }
            DocIdSetIterator docs = scorer.iterator();
            Bits liveDocs = leaf.reader().getLiveDocs();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    Throwable killCause = killed.get();
                    if (killCause != null) {
                        Exceptions.rethrowUnchecked(killCause);
                    }
                    for (int i = 0; i < aggregators.size(); ++i) {
                        aggregators.get(i).apply(ramAccounting, doc, cells[i]);
                    }
                }
                doc = docs.nextDoc();
            }
        }
        for (int i = 0; i < aggregators.size(); ++i) {
            cells[i] = aggregators.get(i).partialResult(ramAccounting, cells[i]);
        }
        return List.of(new RowN(cells));
    }

    @Nullable
    private static AggregationProjection aggregateProjection(Collection<? extends Projection> shardProjections) {
        if (shardProjections.size() != 1) {
            return null;
        }
        Projection projection = shardProjections.iterator().next();
        if (!(projection instanceof AggregationProjection)) {
            return null;
        }
        return (AggregationProjection)projection;
    }

    private static class AggregationInputToReferenceResolver
    extends SymbolVisitor<List<Symbol>, Symbol> {
        public static final AggregationInputToReferenceResolver INSTANCE = new AggregationInputToReferenceResolver();

        private AggregationInputToReferenceResolver() {
        }

        @Override
        public Symbol visitFunction(Function function, List<Symbol> toCollect) {
            Symbol arg;
            if (function.name().equals("cast") && (arg = function.arguments().get(0)) != null && function.valueType().id() == DataTypes.NUMERIC.id()) {
                return arg.accept(this, toCollect);
            }
            return null;
        }

        @Override
        public Symbol visitReference(Reference reference, List<Symbol> context) {
            return reference;
        }

        @Override
        public Symbol visitInputColumn(InputColumn inputColumn, List<Symbol> toCollect) {
            Symbol collectSymbol = toCollect.get(inputColumn.index());
            if (collectSymbol == null) {
                return null;
            }
            return collectSymbol.accept(this, toCollect);
        }
    }
}

