/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import com.google.common.collect.ImmutableList;
import io.crate.blob.v2.BlobShard;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.TransportActionProvider;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.RowsTransformer;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.BlobOrderedDocCollector;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.jobs.NodeJobsCounter;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.blob.BlobReferenceResolver;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import java.io.File;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;

public class BlobShardCollectorProvider
extends ShardCollectorProvider {
    private final BlobShard blobShard;
    private final InputFactory inputFactory;

    public BlobShardCollectorProvider(BlobShard blobShard, ClusterService clusterService, Schemas schemas, NodeJobsCounter nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, TransportActionProvider transportActionProvider) {
        super(clusterService, circuitBreakerService, schemas, nodeJobsCounter, nodeCtx, threadPool, settings, transportActionProvider, blobShard.indexShard(), new ShardRowContext(blobShard, clusterService));
        this.inputFactory = new InputFactory(nodeCtx);
        this.blobShard = blobShard;
    }

    @Override
    @Nullable
    protected BatchIterator<Row> getProjectionFusedIterator(RoutedCollectPhase normalizedPhase, CollectTask collectTask) {
        return null;
    }

    @Override
    protected BatchIterator<Row> getUnorderedIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) {
        return InMemoryBatchIterator.of(this.getBlobRows(collectTask.txnCtx(), collectPhase, requiresScroll), SentinelRow.SENTINEL, true);
    }

    private Iterable<Row> getBlobRows(TransactionContext txnCtx, RoutedCollectPhase collectPhase, boolean requiresRepeat) {
        Iterable<File> files = this.blobShard.blobContainer().getFiles();
        Iterable<Row> rows = RowsTransformer.toRowsIterable(txnCtx, this.inputFactory, BlobReferenceResolver.INSTANCE, collectPhase, files);
        if (requiresRepeat) {
            return ImmutableList.copyOf(rows);
        }
        return rows;
    }

    @Override
    public OrderedDocCollector getOrderedCollector(RoutedCollectPhase collectPhase, SharedShardContext sharedShardContext, CollectTask collectTask, boolean requiresRepeat) {
        RoutedCollectPhase normalizedCollectPhase = collectPhase.normalize(this.shardNormalizer, collectTask.txnCtx());
        return new BlobOrderedDocCollector(this.blobShard.indexShard().shardId(), this.getBlobRows(collectTask.txnCtx(), normalizedCollectPhase, requiresRepeat));
    }
}

