/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class TDigestState
extends AVLTreeDigest {
    private static final int DEFAULT_COMPRESSION = 100;
    private final double compression;
    private double[] fractions;

    TDigestState(double compression, double[] fractions) {
        super(compression);
        this.compression = compression;
        this.fractions = fractions;
    }

    static TDigestState createEmptyState() {
        return new TDigestState(100.0, new double[0]);
    }

    boolean isEmpty() {
        return this.fractions.length == 0;
    }

    public double compression() {
        return this.compression;
    }

    double[] fractions() {
        return this.fractions;
    }

    void fractions(double[] fractions) {
        this.fractions = fractions;
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        out.writeDouble(state.compression);
        out.writeDoubleArray(state.fractions);
        out.writeVInt(state.centroidCount());
        for (Centroid centroid : state.centroids()) {
            out.writeDouble(centroid.mean());
            out.writeVLong(centroid.count());
        }
    }

    public static TDigestState read(StreamInput in) throws IOException {
        double compression = in.readDouble();
        double[] fractions = in.readDoubleArray();
        TDigestState state = new TDigestState(compression, fractions);
        int n = in.readVInt();
        for (int i = 0; i < n; ++i) {
            state.add(in.readDouble(), in.readVInt());
        }
        return state;
    }
}

