/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.common.MutableDouble;
import io.crate.common.MutableFloat;
import io.crate.common.MutableLong;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.execution.engine.aggregation.impl.KahanSummationForDouble;
import io.crate.execution.engine.aggregation.impl.KahanSummationForFloat;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import javax.annotation.Nullable;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.index.mapper.MappedFieldType;

public class SumAggregation<T extends Number>
extends AggregationFunction<T, T> {
    public static final String NAME = "sum";
    private final Signature signature;
    private final Signature boundSignature;
    private final BinaryOperator<T> addition;
    private final BinaryOperator<T> subtraction;
    private final DataType<T> returnType;
    private final int bytesSize;

    public static void register(AggregationImplModule mod) {
        BinaryOperator add = Math::addExact;
        BinaryOperator sub = Math::subtractExact;
        mod.register(Signature.aggregate(NAME, DataTypes.FLOAT.getTypeSignature(), DataTypes.FLOAT.getTypeSignature()), SumAggregation.getSumAggregationForFloatFactory());
        mod.register(Signature.aggregate(NAME, DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), SumAggregation.getSumAggregationForDoubleFactory());
        for (DataType dataType : List.of(DataTypes.BYTE, DataTypes.SHORT, DataTypes.INTEGER, DataTypes.LONG)) {
            mod.register(Signature.aggregate(NAME, dataType.getTypeSignature(), DataTypes.LONG.getTypeSignature()), (signature, boundSignature) -> new SumAggregation<Long>(DataTypes.LONG, add, sub, (Signature)signature, (Signature)boundSignature));
        }
    }

    @VisibleForTesting
    private SumAggregation(DataType<T> returnType, BinaryOperator<T> addition, BinaryOperator<T> subtraction, Signature signature, Signature boundSignature) {
        this.addition = addition;
        this.subtraction = subtraction;
        this.returnType = returnType;
        this.bytesSize = returnType == DataTypes.FLOAT ? DataTypes.FLOAT.fixedSize() : (returnType == DataTypes.DOUBLE ? DataTypes.DOUBLE.fixedSize() : DataTypes.LONG.fixedSize());
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    @Nullable
    public T newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(this.bytesSize);
        return null;
    }

    @Override
    public T iterate(RamAccounting ramAccounting, MemoryManager memoryManager, T state, Input[] args) throws CircuitBreakingException {
        return (T)this.reduce(ramAccounting, state, (T)((Number)this.returnType.sanitizeValue(args[0].value())));
    }

    @Override
    public T reduce(RamAccounting ramAccounting, T state1, T state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        return (T)((Number)this.addition.apply(state1, state2));
    }

    @Override
    public T terminatePartial(RamAccounting ramAccounting, T state) {
        return state;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.getReturnType().createType();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public T removeFromAggregatedState(RamAccounting ramAccounting, T previousAggState, Input[] stateToRemove) {
        return (T)((Number)this.subtraction.apply(previousAggState, (Number)this.returnType.sanitizeValue(stateToRemove[0].value())));
    }

    @Override
    public DocValueAggregator<?> getDocValueAggregator(List<DataType<?>> argumentTypes, List<MappedFieldType> fieldTypes) {
        switch (argumentTypes.get(0).id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                return new SumLong(fieldTypes.get(0).name());
            }
            case 7: {
                return new SumFloat(fieldTypes.get(0).name());
            }
            case 6: {
                return new SumDouble(fieldTypes.get(0).name());
            }
        }
        return null;
    }

    private static BiFunction<Signature, Signature, FunctionImplementation> getSumAggregationForDoubleFactory() {
        return (signature, boundSignature) -> {
            KahanSummationForDouble kahanSummation = new KahanSummationForDouble();
            return new SumAggregation<Double>(DataTypes.DOUBLE, kahanSummation::sum, (n1, n2) -> n1 - n2, (Signature)signature, (Signature)boundSignature);
        };
    }

    private static BiFunction<Signature, Signature, FunctionImplementation> getSumAggregationForFloatFactory() {
        return (signature, boundSignature) -> {
            KahanSummationForFloat kahanSummation = new KahanSummationForFloat();
            return new SumAggregation<Float>(DataTypes.FLOAT, kahanSummation::sum, (n1, n2) -> Float.valueOf(n1.floatValue() - n2.floatValue()), (Signature)signature, (Signature)boundSignature);
        };
    }

    @VisibleForTesting
    public static class SumLong
    implements DocValueAggregator<MutableLong> {
        private final String columnName;
        private SortedNumericDocValues values;

        SumLong(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableLong initialState(RamAccounting ramAccounting) {
            ramAccounting.addBytes(DataTypes.LONG.fixedSize());
            return new MutableLong(0L);
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableLong state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
                state.setValue(Math.addExact(state.value(), this.values.nextValue()));
            }
        }

        public Long partialResult(RamAccounting ramAccounting, MutableLong state) {
            return state.hasValue() ? Long.valueOf(state.value()) : null;
        }
    }

    static class SumFloat
    implements DocValueAggregator<MutableFloat> {
        private final String columnName;
        private SortedNumericDocValues values;
        private final KahanSummationForFloat kahanSummation = new KahanSummationForFloat();

        SumFloat(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableFloat initialState(RamAccounting ramAccounting) {
            ramAccounting.addBytes(DataTypes.FLOAT.fixedSize());
            return new MutableFloat(0.0f);
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableFloat state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
                float value = this.kahanSummation.sum(state.value(), NumericUtils.sortableIntToFloat((int)((int)this.values.nextValue())));
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableFloat state) {
            return state.hasValue() ? Float.valueOf(state.value()) : null;
        }
    }

    static class SumDouble
    implements DocValueAggregator<MutableDouble> {
        private final String columnName;
        private SortedNumericDocValues values;
        private final KahanSummationForDouble kahanSummation = new KahanSummationForDouble();

        SumDouble(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableDouble initialState(RamAccounting ramAccounting) {
            ramAccounting.addBytes(DataTypes.DOUBLE.fixedSize());
            return new MutableDouble(0.0);
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableDouble state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
                double value = this.kahanSummation.sum(state.value(), NumericUtils.sortableLongToDouble((long)this.values.nextValue()));
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableDouble state) {
            return state.hasValue() ? Double.valueOf(state.value()) : null;
        }
    }
}

