/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.StringSizeEstimator;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class StringAgg
extends AggregationFunction<StringAggState, String> {
    private static final String NAME = "string_agg";
    public static final Signature SIGNATURE = Signature.aggregate("string_agg", DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature());
    private static final int LIST_ENTRY_OVERHEAD = 32;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(AggregationImplModule mod) {
        mod.register(SIGNATURE, StringAgg::new);
    }

    public StringAgg(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public StringAggState newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        return new StringAggState();
    }

    @Override
    public StringAggState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, StringAggState state, Input ... args) throws CircuitBreakingException {
        String expression = (String)args[0].value();
        if (expression == null) {
            return state;
        }
        ramAccounting.addBytes(32L + StringSizeEstimator.estimate(expression));
        String delimiter = (String)args[1].value();
        if (delimiter != null) {
            if (state.firstDelimiter == null && state.values.isEmpty()) {
                state.firstDelimiter = delimiter;
            } else {
                ramAccounting.addBytes(32L + StringSizeEstimator.estimate(delimiter));
                state.values.add(delimiter);
            }
        }
        state.values.add(expression);
        return state;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public StringAggState removeFromAggregatedState(RamAccounting ramAccounting, StringAggState previousAggState, Input[] stateToRemove) {
        String expression = (String)stateToRemove[0].value();
        if (expression == null) {
            return previousAggState;
        }
        String delimiter = (String)stateToRemove[1].value();
        int indexOfExpression = previousAggState.values.indexOf(expression);
        if (indexOfExpression > -1) {
            String elementNextToExpression;
            ramAccounting.addBytes(-32L + StringSizeEstimator.estimate(expression));
            if (delimiter != null && (elementNextToExpression = previousAggState.values.get(indexOfExpression + 1)).equalsIgnoreCase(delimiter)) {
                previousAggState.values.remove(indexOfExpression + 1);
            }
            previousAggState.values.remove(indexOfExpression);
        }
        return previousAggState;
    }

    @Override
    public StringAggState reduce(RamAccounting ramAccounting, StringAggState state1, StringAggState state2) {
        if (state1.values.isEmpty()) {
            return state2;
        }
        if (state2.values.isEmpty()) {
            return state1;
        }
        if (state2.firstDelimiter != null) {
            state1.values.add(state2.firstDelimiter);
        }
        state1.values.addAll(state2.values);
        return state1;
    }

    @Override
    public String terminatePartial(RamAccounting ramAccounting, StringAggState state) {
        List<String> values = state.values;
        if (values.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            sb.append(values.get(i));
        }
        return sb.toString();
    }

    @Override
    public DataType<?> partialType() {
        return StringAggStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    static {
        DataTypes.register(StringAggStateType.INSTANCE.id(), in -> StringAggStateType.INSTANCE);
    }

    static class StringAggState
    implements Writeable {
        private final List<String> values;
        private String firstDelimiter;

        public StringAggState() {
            this.values = new ArrayList<String>();
        }

        public StringAggState(StreamInput in) throws IOException {
            this.values = in.readList(StreamInput::readString);
            this.firstDelimiter = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.values);
            out.writeOptionalString(this.firstDelimiter);
        }
    }

    static class StringAggStateType
    extends DataType<StringAggState>
    implements Streamer<StringAggState> {
        static final StringAggStateType INSTANCE = new StringAggStateType();

        StringAggStateType() {
        }

        @Override
        public int id() {
            return 1025;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "string_list";
        }

        @Override
        public Streamer<StringAggState> streamer() {
            return this;
        }

        @Override
        public StringAggState sanitizeValue(Object value) {
            return (StringAggState)value;
        }

        @Override
        public int compare(StringAggState val1, StringAggState val2) {
            return 0;
        }

        @Override
        public StringAggState readValueFrom(StreamInput in) throws IOException {
            return new StringAggState(in);
        }

        @Override
        public void writeValueTo(StreamOutput out, StringAggState val) throws IOException {
            val.writeTo(out);
        }
    }
}

