/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.CheckedBiConsumer;

public class SortedNumericDocValueAggregator<T>
implements DocValueAggregator<T> {
    private final String columnName;
    private final Function<RamAccounting, T> stateInitializer;
    private final CheckedBiConsumer<SortedNumericDocValues, T, IOException> docValuesConsumer;
    private SortedNumericDocValues values;

    public SortedNumericDocValueAggregator(String columnName, Function<RamAccounting, T> stateInitializer, CheckedBiConsumer<SortedNumericDocValues, T, IOException> docValuesConsumer) {
        this.columnName = columnName;
        this.stateInitializer = stateInitializer;
        this.docValuesConsumer = docValuesConsumer;
    }

    @Override
    public T initialState(RamAccounting ramAccounting) {
        return this.stateInitializer.apply(ramAccounting);
    }

    @Override
    public void loadDocValues(LeafReader reader) throws IOException {
        this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
    }

    @Override
    public void apply(RamAccounting ramAccounting, int doc, T state) throws IOException {
        if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
            this.docValuesConsumer.accept(this.values, (SortedNumericDocValues)state);
        }
    }

    @Override
    @Nullable
    public Object partialResult(RamAccounting ramAccounting, T state) {
        return state;
    }
}

