/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

public class OverflowAwareMutableLong {
    private long primitiveSum;
    private BigDecimal bigDecimalSum = null;
    private boolean hasValue;

    public OverflowAwareMutableLong(long value) {
        this.primitiveSum = value;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @VisibleForTesting
    long primitiveSum() {
        return this.primitiveSum;
    }

    @Nullable
    @VisibleForTesting
    BigDecimal bigDecimalSum() {
        return this.bigDecimalSum;
    }

    public void add(long value) {
        this.hasValue = true;
        if (this.bigDecimalSum == null) {
            long newSum = this.primitiveSum + value;
            if (((this.primitiveSum ^ newSum) & (value ^ newSum)) < 0L) {
                this.bigDecimalSum = BigDecimal.valueOf(this.primitiveSum).add(BigDecimal.valueOf(value));
            } else {
                this.primitiveSum = newSum;
            }
        } else {
            this.bigDecimalSum = this.bigDecimalSum.add(BigDecimal.valueOf(value));
        }
    }

    public BigDecimal value() {
        return Objects.requireNonNullElseGet(this.bigDecimalSum, () -> BigDecimal.valueOf(this.primitiveSum));
    }
}

