/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.common.MutableDouble;
import io.crate.common.MutableFloat;
import io.crate.common.MutableLong;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.index.mapper.MappedFieldType;

public abstract class MaximumAggregation
extends AggregationFunction<Comparable, Comparable> {
    public static final String NAME = "max";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(AggregationImplModule mod) {
        for (DataType<?> supportedType : DataTypes.PRIMITIVE_TYPES) {
            boolean fixedWidthType = supportedType instanceof FixedWidthType;
            mod.register(Signature.aggregate(NAME, supportedType.getTypeSignature(), supportedType.getTypeSignature()), (signature, boundSignature) -> fixedWidthType ? new FixedMaximumAggregation((Signature)signature, (Signature)boundSignature) : new VariableMaximumAggregation((Signature)signature, (Signature)boundSignature));
        }
    }

    private MaximumAggregation(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.getReturnType().createType();
    }

    @Override
    public Comparable iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Comparable state, Input ... args) throws CircuitBreakingException {
        Object value = args[0].value();
        return this.reduce(ramAccounting, state, (Comparable)value);
    }

    @Override
    public Comparable terminatePartial(RamAccounting ramAccounting, Comparable state) {
        return state;
    }

    private static class FixedMaximumAggregation
    extends MaximumAggregation {
        private final int size = ((FixedWidthType)((Object)this.partialType())).fixedSize();

        public FixedMaximumAggregation(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public DocValueAggregator<?> getDocValueAggregator(List<DataType<?>> argumentTypes, List<MappedFieldType> fieldTypes) {
            DataType<?> arg = argumentTypes.get(0);
            switch (arg.id()) {
                case 2: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    return new LongMax(fieldTypes.get(0).name(), arg);
                }
                case 7: {
                    return new FloatMax(fieldTypes.get(0).name());
                }
                case 6: {
                    return new DoubleMax(fieldTypes.get(0).name());
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Comparable newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
            ramAccounting.addBytes(this.size);
            return null;
        }

        @Override
        public Comparable reduce(RamAccounting ramAccounting, Comparable state1, Comparable state2) {
            if (state1 == null) {
                return state2;
            }
            if (state2 == null) {
                return state1;
            }
            if (state1.compareTo(state2) < 0) {
                return state2;
            }
            return state1;
        }
    }

    private static class VariableMaximumAggregation
    extends MaximumAggregation {
        private final SizeEstimator<Object> estimator = SizeEstimatorFactory.create(this.partialType());

        VariableMaximumAggregation(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        @Nullable
        public Comparable newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
            return null;
        }

        @Override
        public Comparable reduce(RamAccounting ramAccounting, Comparable state1, Comparable state2) {
            if (state1 == null) {
                if (state2 != null) {
                    ramAccounting.addBytes(this.estimator.estimateSize(state2));
                }
                return state2;
            }
            if (state2 == null) {
                return state1;
            }
            if (state1.compareTo(state2) < 0) {
                ramAccounting.addBytes(this.estimator.estimateSizeDelta(state1, state2));
                return state2;
            }
            return state1;
        }
    }

    private static class FloatMax
    implements DocValueAggregator<MutableFloat> {
        private final String columnName;
        private SortedNumericDocValues values;

        public FloatMax(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableFloat initialState(RamAccounting ramAccounting) {
            ramAccounting.addBytes(DataTypes.FLOAT.fixedSize());
            return new MutableFloat(Float.MIN_VALUE);
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableFloat state) throws IOException {
            float value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && (value = NumericUtils.sortableIntToFloat((int)((int)this.values.nextValue()))) > state.value()) {
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableFloat state) {
            if (state.hasValue()) {
                return Float.valueOf(state.value());
            }
            return null;
        }
    }

    private static class DoubleMax
    implements DocValueAggregator<MutableDouble> {
        private final String columnName;
        private SortedNumericDocValues values;

        public DoubleMax(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableDouble initialState(RamAccounting ramAccounting) {
            ramAccounting.addBytes(DataTypes.DOUBLE.fixedSize());
            return new MutableDouble(Double.MIN_VALUE);
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableDouble state) throws IOException {
            double value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && (value = NumericUtils.sortableLongToDouble((long)this.values.nextValue())) > state.value()) {
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableDouble state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }

    private static class LongMax
    implements DocValueAggregator<MutableLong> {
        private final String columnName;
        private final DataType<?> partialType;
        private SortedNumericDocValues values;

        public LongMax(String columnName, DataType<?> partialType) {
            this.columnName = columnName;
            this.partialType = partialType;
        }

        @Override
        public MutableLong initialState(RamAccounting ramAccounting) {
            ramAccounting.addBytes(DataTypes.LONG.fixedSize());
            return new MutableLong(Long.MIN_VALUE);
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableLong state) throws IOException {
            long value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && (value = this.values.nextValue()) > state.value()) {
                state.setValue(value);
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, MutableLong state) {
            if (state.hasValue()) {
                return this.partialType.sanitizeValue(state.value());
            }
            return null;
        }
    }
}

