/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.common.MutableLong;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.execution.engine.aggregation.impl.BinaryDocValueAggregator;
import io.crate.execution.engine.aggregation.impl.SortedNumericDocValueAggregator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.memory.MemoryManager;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;

public class CountAggregation
extends AggregationFunction<MutableLong, Long> {
    public static final String NAME = "count";
    public static final Signature SIGNATURE = Signature.aggregate("count", TypeSignature.parseTypeSignature("V"), DataTypes.LONG.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("V"));
    public static final Signature COUNT_STAR_SIGNATURE = Signature.aggregate("count", DataTypes.LONG.getTypeSignature());
    private final Signature signature;
    private final Signature boundSignature;
    private final boolean hasArgs;

    public static void register(AggregationImplModule mod) {
        mod.register(SIGNATURE, (signature, boundSignature) -> new CountAggregation((Signature)signature, (Signature)boundSignature, true));
        mod.register(COUNT_STAR_SIGNATURE, (signature, boundSignature) -> new CountAggregation((Signature)signature, (Signature)boundSignature, false));
    }

    private CountAggregation(Signature signature, Signature boundSignature, boolean hasArgs) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.hasArgs = hasArgs;
    }

    @Override
    public MutableLong iterate(RamAccounting ramAccounting, MemoryManager memoryManager, MutableLong state, Input ... args) {
        if (!this.hasArgs || args[0].value() != null) {
            return state.add(1L);
        }
        return state;
    }

    @Override
    @Nullable
    public MutableLong newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(LongStateType.INSTANCE.fixedSize());
        return new MutableLong(0L);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol arg;
        assert (function.arguments().size() <= 1) : "function's number of arguments must be 0 or 1";
        if (function.arguments().size() == 1 && (arg = function.arguments().get(0)) instanceof Input) {
            if (((Input)((Object)arg)).value() == null) {
                return Literal.of(0L);
            }
            return new Function(COUNT_STAR_SIGNATURE, List.of(), DataTypes.LONG);
        }
        return function;
    }

    @Override
    public DataType<?> partialType() {
        return LongStateType.INSTANCE;
    }

    @Override
    public MutableLong reduce(RamAccounting ramAccounting, MutableLong state1, MutableLong state2) {
        return state1.add(state2.value());
    }

    @Override
    public Long terminatePartial(RamAccounting ramAccounting, MutableLong state) {
        return state.value();
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public MutableLong removeFromAggregatedState(RamAccounting ramAccounting, MutableLong previousAggState, Input[] stateToRemove) {
        if (!this.hasArgs || stateToRemove[0].value() != null) {
            return previousAggState.sub(1L);
        }
        return previousAggState;
    }

    @Override
    public DocValueAggregator<?> getDocValueAggregator(List<DataType<?>> argumentTypes, List<MappedFieldType> fieldTypes) {
        if (argumentTypes.size() == 1) {
            switch (argumentTypes.get(0).id()) {
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: {
                    return new SortedNumericDocValueAggregator<MutableLong>(fieldTypes.get(0).name(), ramAccounting -> {
                        ramAccounting.addBytes(LongStateType.INSTANCE.fixedSize());
                        return new MutableLong(0L);
                    }, (values, state) -> state.add(1L));
                }
                case 4: 
                case 5: {
                    return new BinaryDocValueAggregator<MutableLong>(fieldTypes.get(0).name(), ramAccounting -> {
                        ramAccounting.addBytes(LongStateType.INSTANCE.fixedSize());
                        return new MutableLong(0L);
                    }, (values, state) -> state.add(1L));
                }
            }
            return null;
        }
        return null;
    }

    static {
        DataTypes.register(16384, in -> LongStateType.INSTANCE);
    }

    public static class LongStateType
    extends DataType<MutableLong>
    implements FixedWidthType,
    Streamer<MutableLong> {
        public static final int ID = 16384;
        public static final LongStateType INSTANCE = new LongStateType();

        @Override
        public int id() {
            return 16384;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "long_state";
        }

        @Override
        public Streamer<MutableLong> streamer() {
            return this;
        }

        @Override
        public MutableLong sanitizeValue(Object value) {
            return (MutableLong)value;
        }

        @Override
        public int compare(MutableLong val1, MutableLong val2) {
            if (val1 == null) {
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return Long.compare(val1.value(), val2.value());
        }

        @Override
        public MutableLong readValueFrom(StreamInput in) throws IOException {
            return new MutableLong(in.readVLong());
        }

        @Override
        public void writeValueTo(StreamOutput out, MutableLong v) throws IOException {
            out.writeVLong(v.value());
        }

        @Override
        public int fixedSize() {
            return DataTypes.LONG.fixedSize();
        }
    }
}

