/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.UncheckedObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;

public class CollectSetAggregation
extends AggregationFunction<Map<Object, Object>, List<Object>> {
    private static final Object PRESENT = null;
    public static final String NAME = "collect_set";
    private final Signature signature;
    private final Signature boundSignature;
    private final DataType<?> partialReturnType;
    private final SizeEstimator<Object> innerTypeEstimator;

    public static void register(AggregationImplModule mod) {
        for (DataType<?> supportedType : DataTypes.PRIMITIVE_TYPES) {
            ArrayType returnType = new ArrayType(supportedType);
            mod.register(Signature.aggregate(NAME, supportedType.getTypeSignature(), returnType.getTypeSignature()), CollectSetAggregation::new);
        }
    }

    private CollectSetAggregation(Signature signature, Signature boundSignature) {
        this.innerTypeEstimator = SizeEstimatorFactory.create(((ArrayType)boundSignature.getReturnType().createType()).innerType());
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.partialReturnType = UncheckedObjectType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public AggregationFunction<Map<Object, Long>, List<Object>> optimizeForExecutionAsWindowFunction() {
        return new RemovableCumulativeCollectSet(this.signature, this.boundSignature);
    }

    @Override
    public Map<Object, Object> iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Map<Object, Object> state, Input ... args) throws CircuitBreakingException {
        Object value = args[0].value();
        if (value == null) {
            return state;
        }
        if (state.put(value, PRESENT) == null) {
            ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)(this.innerTypeEstimator.estimateSize(value) + 36L)));
        }
        return state;
    }

    @Override
    @Nullable
    public Map<Object, Object> newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)64L));
        return new HashMap<Object, Object>();
    }

    @Override
    public DataType<?> partialType() {
        return this.partialReturnType;
    }

    @Override
    public Map<Object, Object> reduce(RamAccounting ramAccounting, Map<Object, Object> state1, Map<Object, Object> state2) {
        for (Object newValue : state2.keySet()) {
            if (state1.put(newValue, PRESENT) != null) continue;
            ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)(this.innerTypeEstimator.estimateSize(newValue) + 36L)));
        }
        return state1;
    }

    @Override
    public List<Object> terminatePartial(RamAccounting ramAccounting, Map<Object, Object> state) {
        return new ArrayList<Object>(state.keySet());
    }

    @Override
    public boolean isRemovableCumulative() {
        return false;
    }

    private static class RemovableCumulativeCollectSet
    extends AggregationFunction<Map<Object, Long>, List<Object>> {
        private final SizeEstimator<Object> innerTypeEstimator;
        private final Signature signature;
        private final Signature boundSignature;
        private final DataType<?> partialType;

        RemovableCumulativeCollectSet(Signature signature, Signature boundSignature) {
            this.innerTypeEstimator = SizeEstimatorFactory.create(((ArrayType)boundSignature.getReturnType().createType()).innerType());
            this.signature = signature;
            this.boundSignature = boundSignature;
            this.partialType = UncheckedObjectType.INSTANCE;
        }

        @Override
        @Nullable
        public Map<Object, Long> newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
            ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)64L));
            return new HashMap<Object, Long>();
        }

        @Override
        public Map<Object, Long> iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Map<Object, Long> state, Input ... args) throws CircuitBreakingException {
            Object value = args[0].value();
            if (value == null) {
                return state;
            }
            RemovableCumulativeCollectSet.upsertOccurrenceForValue(state, value, 1L, ramAccounting, this.innerTypeEstimator);
            return state;
        }

        private static void upsertOccurrenceForValue(Map<Object, Long> state, Object value, long occurrenceIncrement, RamAccounting ramAccountingContext, SizeEstimator<Object> innerTypeEstimator) {
            state.compute(value, (k, v) -> {
                if (v == null) {
                    ramAccountingContext.addBytes(RamUsageEstimator.alignObjectSize((long)(innerTypeEstimator.estimateSize(value) + 48L)));
                    return occurrenceIncrement;
                }
                return v + occurrenceIncrement;
            });
        }

        @Override
        public boolean isRemovableCumulative() {
            return true;
        }

        @Override
        public Map<Object, Long> removeFromAggregatedState(RamAccounting ramAccounting, Map<Object, Long> previousAggState, Input[] stateToRemove) {
            Object value = stateToRemove[0].value();
            if (value == null) {
                return previousAggState;
            }
            Long numTimesValueSeen = previousAggState.get(value);
            if (numTimesValueSeen == null) {
                return previousAggState;
            }
            if (numTimesValueSeen == 1L) {
                previousAggState.remove(value);
                ramAccounting.addBytes(-RamUsageEstimator.alignObjectSize((long)(this.innerTypeEstimator.estimateSize(value) + 48L)));
            } else {
                previousAggState.put(value, numTimesValueSeen - 1L);
            }
            return previousAggState;
        }

        @Override
        public Map<Object, Long> reduce(RamAccounting ramAccounting, Map<Object, Long> state1, Map<Object, Long> state2) {
            for (Map.Entry<Object, Long> state2Entry : state2.entrySet()) {
                RemovableCumulativeCollectSet.upsertOccurrenceForValue(state1, state2Entry.getKey(), state2Entry.getValue(), ramAccounting, this.innerTypeEstimator);
            }
            return state1;
        }

        @Override
        public List<Object> terminatePartial(RamAccounting ramAccounting, Map<Object, Long> state) {
            return new ArrayList<Object>(state.keySet());
        }

        @Override
        public DataType<?> partialType() {
            return this.partialType;
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }
    }
}

