/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class BinaryDocValueAggregator<T>
implements DocValueAggregator<T> {
    private final String columnName;
    private final Function<RamAccounting, T> stateInitializer;
    private final CheckedBiConsumer<SortedBinaryDocValues, T, IOException> docValuesConsumer;
    protected SortedBinaryDocValues values;

    public BinaryDocValueAggregator(String columnName, Function<RamAccounting, T> stateInitializer, CheckedBiConsumer<SortedBinaryDocValues, T, IOException> docValuesConsumer) {
        this.columnName = columnName;
        this.stateInitializer = stateInitializer;
        this.docValuesConsumer = docValuesConsumer;
    }

    @Override
    public T initialState(RamAccounting ramAccounting) {
        return this.stateInitializer.apply(ramAccounting);
    }

    @Override
    public void loadDocValues(LeafReader reader) throws IOException {
        this.values = FieldData.toString(DocValues.getSortedSet((LeafReader)reader, (String)this.columnName));
    }

    @Override
    public void apply(RamAccounting ramAccounting, int doc, T state) throws IOException {
        if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
            this.docValuesConsumer.accept(this.values, (SortedBinaryDocValues)state);
        }
    }

    @Override
    @Nullable
    public Object partialResult(RamAccounting ramAccounting, T state) {
        return state;
    }
}

