/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.common.collections.Lists2;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.execution.engine.aggregation.impl.SortedNumericDocValueAggregator;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;

public class AverageAggregation
extends AggregationFunction<AverageState, Double> {
    public static final String[] NAMES = new String[]{"avg", "mean"};
    public static final String NAME = NAMES[0];
    private static final List<DataType<?>> SUPPORTED_TYPES;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(AggregationImplModule mod) {
        for (String functionName : NAMES) {
            for (DataType<?> supportedType : SUPPORTED_TYPES) {
                mod.register(Signature.aggregate(functionName, supportedType.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), AverageAggregation::new);
            }
        }
    }

    AverageAggregation(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public AverageState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, AverageState state, Input ... args) {
        Number value;
        if (state != null && (value = (Number)args[0].value()) != null) {
            ++state.count;
            state.sum += value.doubleValue();
        }
        return state;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public AverageState removeFromAggregatedState(RamAccounting ramAccounting, AverageState previousAggState, Input[] stateToRemove) {
        Number value;
        if (previousAggState != null && (value = (Number)stateToRemove[0].value()) != null) {
            --previousAggState.count;
            previousAggState.sum -= value.doubleValue();
        }
        return previousAggState;
    }

    @Override
    public AverageState reduce(RamAccounting ramAccounting, AverageState state1, AverageState state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        state1.count += state2.count;
        state1.sum += state2.sum;
        return state1;
    }

    @Override
    public Double terminatePartial(RamAccounting ramAccounting, AverageState state) {
        return state.value();
    }

    @Override
    @Nullable
    public AverageState newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(AverageStateType.INSTANCE.fixedSize());
        return new AverageState();
    }

    @Override
    public DataType<?> partialType() {
        return AverageStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public DocValueAggregator<?> getDocValueAggregator(List<DataType<?>> argumentTypes, List<MappedFieldType> fieldTypes) {
        switch (argumentTypes.get(0).id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                return new SortedNumericDocValueAggregator<AverageState>(fieldTypes.get(0).name(), ramAccounting -> {
                    ramAccounting.addBytes(AverageStateType.INSTANCE.fixedSize());
                    return new AverageState();
                }, (values, state) -> {
                    state.sum += (double)values.nextValue();
                    ++state.count;
                });
            }
            case 7: {
                return new SortedNumericDocValueAggregator<AverageState>(fieldTypes.get(0).name(), ramAccounting -> {
                    ramAccounting.addBytes(AverageStateType.INSTANCE.fixedSize());
                    return new AverageState();
                }, (values, state) -> {
                    float value = NumericUtils.sortableIntToFloat((int)((int)values.nextValue()));
                    state.sum += (double)value;
                    ++state.count;
                });
            }
            case 6: {
                return new SortedNumericDocValueAggregator<AverageState>(fieldTypes.get(0).name(), ramAccounting -> {
                    ramAccounting.addBytes(AverageStateType.INSTANCE.fixedSize());
                    return new AverageState();
                }, (values, state) -> {
                    double value = NumericUtils.sortableLongToDouble((long)values.nextValue());
                    state.sum += value;
                    ++state.count;
                });
            }
        }
        return null;
    }

    static {
        DataTypes.register(1024, in -> AverageStateType.INSTANCE);
        SUPPORTED_TYPES = Lists2.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, DataTypes.TIMESTAMPZ);
    }

    public static class AverageState
    implements Comparable<AverageState> {
        public double sum = 0.0;
        public long count = 0L;

        public Double value() {
            if (this.count > 0L) {
                return this.sum / (double)this.count;
            }
            return null;
        }

        @Override
        public int compareTo(AverageState o) {
            if (o == null) {
                return 1;
            }
            int compare = Double.compare(this.sum, o.sum);
            if (compare == 0) {
                return Long.compare(this.count, o.count);
            }
            return compare;
        }

        public String toString() {
            return "sum: " + this.sum + " count: " + this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AverageState that = (AverageState)o;
            return Objects.equals(that.value(), this.value());
        }

        public int hashCode() {
            return Objects.hash(this.value());
        }
    }

    public static class AverageStateType
    extends DataType<AverageState>
    implements FixedWidthType,
    Streamer<AverageState> {
        public static final int ID = 1024;
        private static final AverageStateType INSTANCE = new AverageStateType();
        private static final int AVERAGE_STATE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(AverageState.class);

        @Override
        public int id() {
            return 1024;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "average_state";
        }

        @Override
        public Streamer<AverageState> streamer() {
            return this;
        }

        @Override
        public AverageState sanitizeValue(Object value) {
            return (AverageState)value;
        }

        @Override
        public int compare(AverageState val1, AverageState val2) {
            if (val1 == null) {
                return -1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public AverageState readValueFrom(StreamInput in) throws IOException {
            AverageState averageState = new AverageState();
            averageState.sum = in.readDouble();
            averageState.count = in.readVLong();
            return averageState;
        }

        @Override
        public void writeValueTo(StreamOutput out, AverageState v) throws IOException {
            out.writeDouble(v.sum);
            out.writeVLong(v.count);
        }

        @Override
        public int fixedSize() {
            return AVERAGE_STATE_SIZE;
        }
    }
}

