/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;

public final class ArrayAgg
extends AggregationFunction<List<Object>, List<Object>> {
    public static final String NAME = "array_agg";
    public static final Signature SIGNATURE = Signature.aggregate("array_agg", TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("array(E)")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E"));
    private final Signature signature;
    private final Signature boundSignature;
    private final SizeEstimator<Object> sizeEstimator;

    public static void register(AggregationImplModule module) {
        module.register(SIGNATURE, ArrayAgg::new);
    }

    public ArrayAgg(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.sizeEstimator = SizeEstimatorFactory.create(boundSignature.getArgumentDataTypes().get(0));
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public List<Object> newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        return new ArrayList<Object>();
    }

    @Override
    public List<Object> iterate(RamAccounting ramAccounting, MemoryManager memoryManager, List<Object> state, Input ... args) throws CircuitBreakingException {
        Object value = args[0].value();
        ramAccounting.addBytes(this.sizeEstimator.estimateSize(value));
        state.add(value);
        return state;
    }

    @Override
    public List<Object> reduce(RamAccounting ramAccounting, List<Object> state1, List<Object> state2) {
        state1.addAll(state2);
        return state1;
    }

    @Override
    public List<Object> terminatePartial(RamAccounting ramAccounting, List<Object> state) {
        return state;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.getReturnType().createType();
    }
}

