/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.common.MutableObject;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;

public class ArbitraryAggregation
extends AggregationFunction<Object, Object> {
    public static final String NAME = "arbitrary";
    private final Signature signature;
    private final Signature boundSignature;
    private final SizeEstimator<Object> partialEstimator;

    public static void register(AggregationImplModule mod) {
        for (DataType<?> supportedType : DataTypes.PRIMITIVE_TYPES) {
            mod.register(Signature.aggregate(NAME, supportedType.getTypeSignature(), supportedType.getTypeSignature()), ArbitraryAggregation::new);
        }
    }

    ArbitraryAggregation(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.partialEstimator = SizeEstimatorFactory.create(this.partialType());
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.getReturnType().createType();
    }

    @Override
    @Nullable
    public Object newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        return null;
    }

    @Override
    public Object iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Object state, Input ... args) {
        return this.reduce(ramAccounting, state, args[0].value());
    }

    @Override
    public Object reduce(RamAccounting ramAccounting, Object state1, Object state2) {
        if (state1 == null) {
            if (state2 != null) {
                ramAccounting.addBytes(this.partialEstimator.estimateSize(state2));
            }
            return state2;
        }
        return state1;
    }

    @Override
    public Object terminatePartial(RamAccounting ramAccounting, Object state) {
        return state;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(List<DataType<?>> argumentTypes, List<MappedFieldType> fieldTypes) {
        DataType<?> dataType = argumentTypes.get(0);
        switch (dataType.id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return new LongArbitraryDocValueAggregator(fieldTypes.get(0).name(), dataType, this.partialEstimator);
            }
            case 7: {
                return new FloatArbitraryDocValueAggregator(fieldTypes.get(0).name(), this.partialEstimator);
            }
            case 6: {
                return new DoubleArbitraryDocValueAggregator(fieldTypes.get(0).name(), this.partialEstimator);
            }
            case 4: 
            case 5: {
                return new ArbitraryBinaryDocValueAggregator(fieldTypes.get(0).name(), dataType, this.partialEstimator);
            }
        }
        return null;
    }

    private static class LongArbitraryDocValueAggregator
    extends ArbitraryNumericDocValueAggregator {
        private final DataType<?> dataType;
        private final SizeEstimator<Object> sizeEstimator;

        public LongArbitraryDocValueAggregator(String columnName, DataType<?> dataType, SizeEstimator<Object> sizeEstimator) {
            super(columnName);
            this.dataType = dataType;
            this.sizeEstimator = sizeEstimator;
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                Object value = this.dataType.sanitizeValue(this.values.nextValue());
                ramAccounting.addBytes(this.sizeEstimator.estimateSize(value));
                state.setValue(value);
            }
        }
    }

    private static class FloatArbitraryDocValueAggregator
    extends ArbitraryNumericDocValueAggregator {
        private final SizeEstimator<Object> sizeEstimator;

        public FloatArbitraryDocValueAggregator(String columnName, SizeEstimator<Object> sizeEstimator) {
            super(columnName);
            this.sizeEstimator = sizeEstimator;
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                float value = NumericUtils.sortableIntToFloat((int)((int)this.values.nextValue()));
                ramAccounting.addBytes(this.sizeEstimator.estimateSize(Float.valueOf(value)));
                state.setValue(Float.valueOf(value));
            }
        }
    }

    private static class DoubleArbitraryDocValueAggregator
    extends ArbitraryNumericDocValueAggregator {
        private final SizeEstimator<Object> sizeEstimator;

        public DoubleArbitraryDocValueAggregator(String columnName, SizeEstimator<Object> sizeEstimator) {
            super(columnName);
            this.sizeEstimator = sizeEstimator;
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                double value = NumericUtils.sortableLongToDouble((long)this.values.nextValue());
                ramAccounting.addBytes(this.sizeEstimator.estimateSize(value));
                state.setValue(value);
            }
        }
    }

    private static class ArbitraryBinaryDocValueAggregator
    implements DocValueAggregator<MutableObject> {
        private final String columnName;
        private final DataType<?> dataType;
        private final SizeEstimator<Object> sizeEstimator;
        private SortedBinaryDocValues values;

        public ArbitraryBinaryDocValueAggregator(String columnName, DataType<?> dataType, SizeEstimator<Object> sizeEstimator) {
            this.columnName = columnName;
            this.dataType = dataType;
            this.sizeEstimator = sizeEstimator;
        }

        @Override
        public MutableObject initialState(RamAccounting ramAccounting) {
            return new MutableObject();
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = FieldData.toString(DocValues.getSortedSet((LeafReader)reader, (String)this.columnName));
        }

        @Override
        public void apply(RamAccounting ramAccounting, int doc, MutableObject state) throws IOException {
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && !state.hasValue()) {
                Object value = this.dataType.sanitizeValue(this.values.nextValue().utf8ToString());
                ramAccounting.addBytes(this.sizeEstimator.estimateSize(value));
                state.setValue(value);
            }
        }

        @Override
        @Nullable
        public Object partialResult(RamAccounting ramAccounting, MutableObject state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }

    private static abstract class ArbitraryNumericDocValueAggregator
    implements DocValueAggregator<MutableObject> {
        private final String columnName;
        protected SortedNumericDocValues values;

        public ArbitraryNumericDocValueAggregator(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public MutableObject initialState(RamAccounting ramAccounting) {
            return new MutableObject();
        }

        @Override
        public void loadDocValues(LeafReader reader) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)reader, (String)this.columnName);
        }

        @Override
        @Nullable
        public Object partialResult(RamAccounting ramAccounting, MutableObject state) {
            if (state.hasValue()) {
                return state.value();
            }
            return null;
        }
    }
}

