/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.crate.breaker.MultiSizeEstimator;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.GroupByMaps;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputCondition;
import io.crate.expression.symbol.AggregateMode;
import io.crate.memory.MemoryManager;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import org.elasticsearch.Version;

public class GroupingCollector<K>
implements Collector<Row, Map<K, Object[]>, Iterable<Row>> {
    private final CollectExpression<Row, ?>[] expressions;
    private final AggregationFunction[] aggregations;
    private final AggregateMode mode;
    private final Input[][] inputs;
    private final Input<Boolean>[] filters;
    private final RamAccounting ramAccounting;
    private final MemoryManager memoryManager;
    private final BiConsumer<K, Object[]> applyKeyToCells;
    private final int numKeyColumns;
    private final BiConsumer<Map<K, Object[]>, K> accountForNewEntry;
    private final java.util.function.Function<Row, K> keyExtractor;
    private final Version indexVersionCreated;
    private final BiConsumer<Map<K, Object[]>, Row> accumulator;
    private final Supplier<Map<K, Object[]>> supplier;
    private final Version minNodeVersion;

    static GroupingCollector<Object> singleKey(CollectExpression<Row, ?>[] expressions, AggregateMode mode, AggregationFunction[] aggregations, Input[][] inputs, Input<Boolean>[] filters, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, Input<?> keyInput, DataType keyType, Version indexVersionCreated) {
        return new GroupingCollector<Object>(expressions, aggregations, mode, inputs, filters, ramAccounting, memoryManager, minNodeVersion, (key, cells) -> {
            cells[0] = key;
        }, 1, GroupByMaps.accountForNewEntry(ramAccounting, SizeEstimatorFactory.create(keyType), keyType), row -> keyInput.value(), indexVersionCreated, GroupByMaps.mapForType(keyType));
    }

    static GroupingCollector<List<Object>> manyKeys(CollectExpression<Row, ?>[] expressions, AggregateMode mode, AggregationFunction[] aggregations, Input[][] inputs, Input<Boolean>[] filters, RamAccounting ramAccountingContext, MemoryManager memoryManager, Version minNodeVersion, List<Input<?>> keyInputs, List<? extends DataType> keyTypes, Version indexVersionCreated) {
        return new GroupingCollector<List<Object>>(expressions, aggregations, mode, inputs, filters, ramAccountingContext, memoryManager, minNodeVersion, GroupingCollector::applyKeysToCells, keyInputs.size(), GroupByMaps.accountForNewEntry(ramAccountingContext, new MultiSizeEstimator(keyTypes), null), row -> GroupingCollector.evalKeyInputs(keyInputs), indexVersionCreated, HashMap::new);
    }

    private static List<Object> evalKeyInputs(List<Input<?>> keyInputs) {
        ArrayList<Object> key = new ArrayList<Object>(keyInputs.size());
        for (Input<?> keyInput : keyInputs) {
            key.add(keyInput.value());
        }
        return key;
    }

    private static void applyKeysToCells(List<Object> keys, Object[] cells) {
        for (int i = 0; i < keys.size(); ++i) {
            cells[i] = keys.get(i);
        }
    }

    private GroupingCollector(CollectExpression<Row, ?>[] expressions, AggregationFunction[] aggregations, AggregateMode mode, Input[][] inputs, Input<Boolean>[] filters, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, BiConsumer<K, Object[]> applyKeyToCells, int numKeyColumns, BiConsumer<Map<K, Object[]>, K> accountForNewEntry, java.util.function.Function<Row, K> keyExtractor, Version indexVersionCreated, Supplier<Map<K, Object[]>> supplier) {
        this.expressions = expressions;
        this.aggregations = aggregations;
        this.mode = mode;
        this.inputs = inputs;
        this.filters = filters;
        this.ramAccounting = ramAccounting;
        this.memoryManager = memoryManager;
        this.applyKeyToCells = applyKeyToCells;
        this.numKeyColumns = numKeyColumns;
        this.accountForNewEntry = accountForNewEntry;
        this.keyExtractor = keyExtractor;
        this.indexVersionCreated = indexVersionCreated;
        this.accumulator = mode == AggregateMode.PARTIAL_FINAL ? this::reduce : this::iter;
        this.supplier = supplier;
        this.minNodeVersion = minNodeVersion;
    }

    @Override
    public Supplier<Map<K, Object[]>> supplier() {
        return this.supplier;
    }

    @Override
    public BiConsumer<Map<K, Object[]>, Row> accumulator() {
        return this.accumulator;
    }

    @Override
    public BinaryOperator<Map<K, Object[]>> combiner() {
        return (state1, state2) -> {
            throw new UnsupportedOperationException("combine not supported");
        };
    }

    @Override
    public java.util.function.Function<Map<K, Object[]>, Iterable<Row>> finisher() {
        return this::mapToRows;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    private void reduce(Map<K, Object[]> statesByKey, Row row) {
        int i;
        for (CollectExpression<Row, ?> expression : this.expressions) {
            expression.setNextRow(row);
        }
        K key = this.keyExtractor.apply(row);
        Object[] states = statesByKey.get(key);
        if (states == null) {
            states = new Object[this.aggregations.length];
            for (i = 0; i < this.aggregations.length; ++i) {
                states[i] = this.inputs[i][0].value();
            }
            this.addWithAccounting(statesByKey, key, states);
        } else {
            for (i = 0; i < this.aggregations.length; ++i) {
                states[i] = this.aggregations[i].reduce(this.ramAccounting, states[i], this.inputs[i][0].value());
            }
        }
    }

    private void addWithAccounting(Map<K, Object[]> statesByKey, K key, Object[] states) {
        this.accountForNewEntry.accept(statesByKey, key);
        statesByKey.put(key, states);
    }

    private void iter(Map<K, Object[]> statesByKey, Row row) {
        for (CollectExpression<Row, ?> expression : this.expressions) {
            expression.setNextRow(row);
        }
        K key = this.keyExtractor.apply(row);
        Object[] states = statesByKey.get(key);
        if (states == null) {
            this.addNewEntry(statesByKey, key);
        } else {
            for (int i = 0; i < this.aggregations.length; ++i) {
                if (!InputCondition.matches(this.filters[i])) continue;
                states[i] = this.aggregations[i].iterate(this.ramAccounting, this.memoryManager, states[i], this.inputs[i]);
            }
        }
    }

    private void addNewEntry(Map<K, Object[]> statesByKey, K key) {
        Object[] states = new Object[this.aggregations.length];
        for (int i = 0; i < this.aggregations.length; ++i) {
            AggregationFunction aggregation = this.aggregations[i];
            Object newState = aggregation.newState(this.ramAccounting, this.indexVersionCreated, this.minNodeVersion, this.memoryManager);
            states[i] = InputCondition.matches(this.filters[i]) ? aggregation.iterate(this.ramAccounting, this.memoryManager, newState, this.inputs[i]) : newState;
        }
        this.addWithAccounting(statesByKey, key, states);
    }

    private Iterable<Row> mapToRows(Map<K, Object[]> statesByKey) {
        return Iterables.transform(statesByKey.entrySet(), (Function)new Function<Map.Entry<K, Object[]>, Row>(){
            RowN row;
            Object[] cells;
            {
                this.row = new RowN(GroupingCollector.this.numKeyColumns + GroupingCollector.this.aggregations.length);
                this.cells = new Object[this.row.numColumns()];
                this.row.cells(this.cells);
            }

            @Nullable
            public Row apply(@Nullable Map.Entry<K, Object[]> input) {
                assert (input != null) : "input must not be null";
                GroupingCollector.this.applyKeyToCells.accept(input.getKey(), this.cells);
                int c = GroupingCollector.this.numKeyColumns;
                Object[] states = input.getValue();
                for (int i = 0; i < states.length; ++i) {
                    this.cells[c] = GroupingCollector.this.mode.finishCollect(GroupingCollector.this.ramAccounting, GroupingCollector.this.aggregations[i], states[i]);
                    ++c;
                }
                return this.row;
            }
        });
    }
}

