/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.breaker.RamAccounting;
import io.crate.breaker.SizeEstimator;
import io.crate.execution.engine.aggregation.PrimitiveMapWithNulls;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.netty.util.collection.ByteObjectHashMap;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.ShortObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.lucene.util.RamUsageEstimator;

public final class GroupByMaps {
    private static final Map<DataType<?>, Integer> ENTRY_OVERHEAD_PER_TYPE = Map.ofEntries(Map.entry(DataTypes.BYTE, 6), Map.entry(DataTypes.SHORT, 6), Map.entry(DataTypes.INTEGER, 8), Map.entry(DataTypes.LONG, 12));

    public static <K, V> BiConsumer<Map<K, V>, K> accountForNewEntry(RamAccounting ramAccounting, SizeEstimator<K> sizeEstimator, @Nullable DataType<K> type) {
        Integer entryOverHead;
        Integer n = entryOverHead = type == null ? null : ENTRY_OVERHEAD_PER_TYPE.get(type);
        if (entryOverHead == null) {
            return (map, k) -> ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)(sizeEstimator.estimateSize(k) + 36L)));
        }
        return (map, k) -> {
            int mapSize = map.size();
            if (mapSize >= 4 && (mapSize & mapSize - 1) == 0) {
                ramAccounting.addBytes((long)mapSize * (long)entryOverHead.intValue());
            }
        };
    }

    public static <K, V> Supplier<Map<K, V>> mapForType(DataType<K> type) {
        switch (type.id()) {
            case 2: {
                return () -> new PrimitiveMapWithNulls(new ByteObjectHashMap());
            }
            case 8: {
                return () -> new PrimitiveMapWithNulls(new ShortObjectHashMap());
            }
            case 9: {
                return () -> new PrimitiveMapWithNulls(new IntObjectHashMap());
            }
            case 10: 
            case 11: 
            case 15: {
                return () -> new PrimitiveMapWithNulls(new LongObjectHashMap());
            }
        }
        return HashMap::new;
    }
}

