/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.breaker.RamAccounting;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.engine.aggregation.AggregateCollector;
import io.crate.execution.engine.aggregation.AggregationContext;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.symbol.AggregateMode;
import io.crate.memory.MemoryManager;
import java.util.List;
import org.elasticsearch.Version;

public class AggregationPipe
implements Projector {
    private final AggregateCollector collector;

    public AggregationPipe(List<CollectExpression<Row, ?>> expressions, AggregateMode aggregateMode, AggregationContext[] aggregations, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, Version indexVersionCreated) {
        AggregationFunction[] functions = new AggregationFunction[aggregations.length];
        Input[][] inputs = new Input[aggregations.length][];
        Input[] filters = new Input[aggregations.length];
        for (int i = 0; i < aggregations.length; ++i) {
            AggregationContext aggregation = aggregations[i];
            functions[i] = aggregation.function();
            inputs[i] = aggregation.inputs();
            filters[i] = aggregation.filter();
        }
        this.collector = new AggregateCollector(expressions, ramAccounting, memoryManager, minNodeVersion, aggregateMode, functions, indexVersionCreated, inputs, filters);
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, this.collector);
    }

    public AggregateCollector getCollector() {
        return this.collector;
    }

    @Override
    public boolean providesIndependentScroll() {
        return true;
    }
}

