/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.breaker.RamAccounting;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputCondition;
import io.crate.expression.symbol.AggregateMode;
import io.crate.memory.MemoryManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.elasticsearch.Version;

public class AggregateCollector
implements Collector<Row, Object[], Iterable<Row>> {
    private final List<? extends CollectExpression<Row, ?>> expressions;
    private final RamAccounting ramAccounting;
    private final MemoryManager memoryManager;
    private final AggregationFunction[] aggregations;
    private final Version indexVersionCreated;
    private final Input<Boolean>[] filters;
    private final Input[][] inputs;
    private final BiConsumer<Object[], Row> accumulator;
    private final Function<Object[], Iterable<Row>> finisher;
    private final Version minNodeVersion;

    public AggregateCollector(List<? extends CollectExpression<Row, ?>> expressions, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, AggregateMode mode, AggregationFunction[] aggregations, Version indexVersionCreated, Input[][] inputs, Input<Boolean>[] filters) {
        this.expressions = expressions;
        this.ramAccounting = ramAccounting;
        this.memoryManager = memoryManager;
        this.minNodeVersion = minNodeVersion;
        this.aggregations = aggregations;
        this.indexVersionCreated = indexVersionCreated;
        this.filters = filters;
        this.inputs = inputs;
        switch (mode) {
            case ITER_PARTIAL: {
                this.accumulator = this::iterate;
                this.finisher = s -> Collections.singletonList(new RowN(s));
                break;
            }
            case ITER_FINAL: {
                this.accumulator = this::iterate;
                this.finisher = this::finishCollect;
                break;
            }
            case PARTIAL_FINAL: {
                this.accumulator = this::reduce;
                this.finisher = this::finishCollect;
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid mode: " + mode.name()));
            }
        }
    }

    @Override
    public Supplier<Object[]> supplier() {
        return this::prepareState;
    }

    @Override
    public BiConsumer<Object[], Row> accumulator() {
        return this.accumulator;
    }

    @Override
    public BinaryOperator<Object[]> combiner() {
        return (state1, state2) -> {
            throw new UnsupportedOperationException("combine not supported");
        };
    }

    @Override
    public Function<Object[], Iterable<Row>> finisher() {
        return this.finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    private Object[] prepareState() {
        Object[] states = new Object[this.aggregations.length];
        for (int i = 0; i < this.aggregations.length; ++i) {
            states[i] = this.aggregations[i].newState(this.ramAccounting, this.indexVersionCreated, this.minNodeVersion, this.memoryManager);
        }
        return states;
    }

    private void iterate(Object[] state, Row row) {
        this.setRow(row);
        for (int i = 0; i < this.aggregations.length; ++i) {
            if (!InputCondition.matches(this.filters[i])) continue;
            state[i] = this.aggregations[i].iterate(this.ramAccounting, this.memoryManager, state[i], this.inputs[i]);
        }
    }

    private void reduce(Object[] state, Row row) {
        this.setRow(row);
        for (int i = 0; i < this.aggregations.length; ++i) {
            state[i] = this.aggregations[i].reduce(this.ramAccounting, state[i], this.inputs[i][0].value());
        }
    }

    private Iterable<Row> finishCollect(Object[] state) {
        for (int i = 0; i < this.aggregations.length; ++i) {
            state[i] = this.aggregations[i].terminatePartial(this.ramAccounting, state[i]);
        }
        return Collections.singletonList(new RowN(state));
    }

    private void setRow(Row row) {
        int expressionsSize = this.expressions.size();
        for (int i = 0; i < expressionsSize; ++i) {
            this.expressions.get(i).setNextRow(row);
        }
    }
}

