/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.engine.JobLauncher;
import io.crate.execution.jobs.JobSetup;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.TransportKillJobsNodeAction;
import io.crate.execution.jobs.transport.TransportJobAction;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public final class PhasesTaskFactory {
    private final ClusterService clusterService;
    private final JobSetup jobSetup;
    private final TasksService tasksService;
    private final IndicesService indicesService;
    private final TransportJobAction jobAction;
    private final TransportKillJobsNodeAction killJobsNodeAction;
    private final Executor searchExecutor;

    @Inject
    public PhasesTaskFactory(ClusterService clusterService, ThreadPool threadPool, JobSetup jobSetup, TasksService tasksService, IndicesService indicesService, TransportJobAction jobAction, TransportKillJobsNodeAction killJobsNodeAction) {
        this.clusterService = clusterService;
        this.jobSetup = jobSetup;
        this.tasksService = tasksService;
        this.indicesService = indicesService;
        this.jobAction = jobAction;
        this.killJobsNodeAction = killJobsNodeAction;
        this.searchExecutor = threadPool.executor("search");
    }

    public JobLauncher create(UUID jobId, List<NodeOperationTree> nodeOperationTreeList) {
        return this.create(jobId, nodeOperationTreeList, false);
    }

    public JobLauncher create(UUID jobId, List<NodeOperationTree> nodeOperationTreeList, boolean enableProfiling) {
        return new JobLauncher(jobId, this.clusterService, this.jobSetup, this.tasksService, this.indicesService, this.jobAction, this.killJobsNodeAction, nodeOperationTreeList, enableProfiling, this.searchExecutor);
    }
}

