/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.common.collections.Tuple;
import io.crate.concurrent.CompletableFutures;
import io.crate.data.CollectingRowConsumer;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.NodeOperationGrouper;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.engine.BucketForwarder;
import io.crate.execution.engine.FailureOnlyResponseListener;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.engine.InterceptingRowConsumer;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.jobs.DownstreamRXTask;
import io.crate.execution.jobs.InstrumentedIndexSearcher;
import io.crate.execution.jobs.JobSetup;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.TransportKillJobsNodeAction;
import io.crate.execution.jobs.transport.JobRequest;
import io.crate.execution.jobs.transport.TransportJobAction;
import io.crate.metadata.TransactionContext;
import io.crate.profile.ProfilingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.profile.query.QueryProfiler;

public final class JobLauncher {
    private final TransportJobAction transportJobAction;
    private final TransportKillJobsNodeAction transportKillJobsNodeAction;
    private final List<NodeOperationTree> nodeOperationTrees;
    private final UUID jobId;
    private final ClusterService clusterService;
    private final JobSetup jobSetup;
    private final TasksService tasksService;
    private final IndicesService indicesService;
    private final boolean enableProfiling;
    private final Executor executor;
    private boolean hasDirectResponse;

    JobLauncher(UUID jobId, ClusterService clusterService, JobSetup jobSetup, TasksService tasksService, IndicesService indicesService, TransportJobAction transportJobAction, TransportKillJobsNodeAction transportKillJobsNodeAction, List<NodeOperationTree> nodeOperationTrees, boolean enableProfiling, Executor executor) {
        this.jobId = jobId;
        this.clusterService = clusterService;
        this.jobSetup = jobSetup;
        this.tasksService = tasksService;
        this.indicesService = indicesService;
        this.transportJobAction = transportJobAction;
        this.transportKillJobsNodeAction = transportKillJobsNodeAction;
        this.nodeOperationTrees = nodeOperationTrees;
        this.enableProfiling = enableProfiling;
        this.executor = executor;
        block0: for (NodeOperationTree nodeOperationTree : nodeOperationTrees) {
            for (NodeOperation nodeOperation : nodeOperationTree.nodeOperations()) {
                if (!ExecutionPhases.hasDirectResponseDownstream(nodeOperation.downstreamNodes())) continue;
                this.hasDirectResponse = true;
                continue block0;
            }
        }
    }

    public void execute(RowConsumer consumer, TransactionContext txnCtx) {
        assert (this.nodeOperationTrees.size() == 1) : "must only have 1 NodeOperationTree for non-bulk operations";
        NodeOperationTree nodeOperationTree = this.nodeOperationTrees.get(0);
        Map<String, Collection<NodeOperation>> operationByServer = NodeOperationGrouper.groupByServer(nodeOperationTree.nodeOperations());
        List<ExecutionPhase> handlerPhases = Collections.singletonList(nodeOperationTree.leaf());
        List<RowConsumer> handlerConsumers = Collections.singletonList(consumer);
        try {
            this.setupTasks(txnCtx, operationByServer, handlerPhases, handlerConsumers);
        }
        catch (Throwable throwable) {
            consumer.accept(null, throwable);
        }
    }

    public List<CompletableFuture<Long>> executeBulk(TransactionContext txnCtx) {
        Iterable<NodeOperation> nodeOperations = this.nodeOperationTrees.stream().flatMap(opTree -> opTree.nodeOperations().stream())::iterator;
        Map<String, Collection<NodeOperation>> operationByServer = NodeOperationGrouper.groupByServer(nodeOperations);
        ArrayList<ExecutionPhase> handlerPhases = new ArrayList<ExecutionPhase>(this.nodeOperationTrees.size());
        ArrayList<RowConsumer> handlerConsumers = new ArrayList<RowConsumer>(this.nodeOperationTrees.size());
        ArrayList<CompletableFuture<Long>> results = new ArrayList<CompletableFuture<Long>>(this.nodeOperationTrees.size());
        for (NodeOperationTree nodeOperationTree : this.nodeOperationTrees) {
            CollectingRowConsumer consumer = new CollectingRowConsumer(Collectors.collectingAndThen(Collectors.summingLong(r -> (Long)r.get(0)), sum -> sum));
            handlerConsumers.add(consumer);
            results.add(consumer.completionFuture());
            handlerPhases.add(nodeOperationTree.leaf());
        }
        try {
            this.setupTasks(txnCtx, operationByServer, handlerPhases, handlerConsumers);
        }
        catch (Throwable throwable) {
            return Collections.singletonList(CompletableFuture.failedFuture(throwable));
        }
        return results;
    }

    private void setupTasks(TransactionContext txnCtx, Map<String, Collection<NodeOperation>> operationByServer, List<ExecutionPhase> handlerPhases, List<RowConsumer> handlerConsumers) throws Throwable {
        assert (handlerPhases.size() == handlerConsumers.size()) : "handlerPhases size must match handlerConsumers size";
        String localNodeId = this.clusterService.localNode().getId();
        Collection<NodeOperation> localNodeOperations = operationByServer.remove(localNodeId);
        if (localNodeOperations == null) {
            localNodeOperations = Collections.emptyList();
        }
        InitializationTracker initializationTracker = new InitializationTracker(operationByServer.size() + 1);
        List<Tuple<ExecutionPhase, RowConsumer>> handlerPhaseAndReceiver = this.createHandlerPhaseAndReceivers(handlerPhases, handlerConsumers, initializationTracker);
        RootTask.Builder builder = this.tasksService.newBuilder(this.jobId, txnCtx.sessionSettings().userName(), localNodeId, operationByServer.keySet());
        SharedShardContexts sharedShardContexts = this.maybeInstrumentProfiler(builder);
        List<CompletableFuture<StreamBucket>> directResponseFutures = this.jobSetup.prepareOnHandler(txnCtx.sessionSettings(), localNodeOperations, builder, handlerPhaseAndReceiver, sharedShardContexts);
        RootTask localTask = this.tasksService.createTask(builder);
        List<PageBucketReceiver> pageBucketReceivers = this.getHandlerBucketReceivers(localTask, handlerPhaseAndReceiver);
        int bucketIdx = 0;
        if (!localNodeOperations.isEmpty() && !directResponseFutures.isEmpty()) {
            assert (directResponseFutures.size() == pageBucketReceivers.size()) : "directResponses size must match pageBucketReceivers";
            CompletableFutures.allAsList(directResponseFutures).whenComplete(BucketForwarder.asConsumer(pageBucketReceivers, bucketIdx, initializationTracker));
            ++bucketIdx;
            try {
                localTask.start();
            }
            catch (Throwable t) {
                this.accountFailureForRemoteOperations(operationByServer, initializationTracker, handlerPhaseAndReceiver, t);
                return;
            }
        }
        try {
            localTask.start();
            initializationTracker.jobInitialized();
        }
        catch (Throwable t) {
            initializationTracker.jobInitializationFailed(t);
            this.accountFailureForRemoteOperations(operationByServer, initializationTracker, handlerPhaseAndReceiver, t);
            return;
        }
        this.sendJobRequests(txnCtx, localNodeId, operationByServer, pageBucketReceivers, handlerPhaseAndReceiver, bucketIdx, initializationTracker);
    }

    private SharedShardContexts maybeInstrumentProfiler(RootTask.Builder builder) {
        if (this.enableProfiling) {
            ArrayList<QueryProfiler> profilers = new ArrayList<QueryProfiler>();
            ProfilingContext profilingContext = new ProfilingContext(profilers);
            builder.profilingContext(profilingContext);
            return new SharedShardContexts(this.indicesService, indexSearcher -> {
                QueryProfiler queryProfiler = new QueryProfiler();
                profilers.add(queryProfiler);
                return new InstrumentedIndexSearcher((Engine.Searcher)indexSearcher, queryProfiler);
            });
        }
        return new SharedShardContexts(this.indicesService, UnaryOperator.identity());
    }

    private void accountFailureForRemoteOperations(Map<String, Collection<NodeOperation>> operationByServer, InitializationTracker initializationTracker, List<Tuple<ExecutionPhase, RowConsumer>> handlerPhaseAndReceiver, Throwable t) {
        for (Tuple<ExecutionPhase, RowConsumer> executionPhaseRowReceiverTuple : handlerPhaseAndReceiver) {
            executionPhaseRowReceiverTuple.v2().accept(null, t);
        }
        for (int i = 0; i < operationByServer.size() + 1; ++i) {
            initializationTracker.jobInitializationFailed(t);
        }
    }

    private List<Tuple<ExecutionPhase, RowConsumer>> createHandlerPhaseAndReceivers(List<ExecutionPhase> handlerPhases, List<RowConsumer> handlerReceivers, InitializationTracker initializationTracker) {
        ArrayList<Tuple<ExecutionPhase, RowConsumer>> handlerPhaseAndReceiver = new ArrayList<Tuple<ExecutionPhase, RowConsumer>>();
        ListIterator<RowConsumer> consumerIt = handlerReceivers.listIterator();
        for (ExecutionPhase handlerPhase : handlerPhases) {
            InterceptingRowConsumer interceptingBatchConsumer = new InterceptingRowConsumer(this.jobId, consumerIt.next(), initializationTracker, this.executor, this.transportKillJobsNodeAction);
            handlerPhaseAndReceiver.add(new Tuple<ExecutionPhase, InterceptingRowConsumer>(handlerPhase, interceptingBatchConsumer));
        }
        return handlerPhaseAndReceiver;
    }

    private void sendJobRequests(TransactionContext txnCtx, String localNodeId, Map<String, Collection<NodeOperation>> operationByServer, List<PageBucketReceiver> pageBucketReceivers, List<Tuple<ExecutionPhase, RowConsumer>> handlerPhases, int bucketIdx, InitializationTracker initializationTracker) {
        for (Map.Entry<String, Collection<NodeOperation>> entry : operationByServer.entrySet()) {
            String serverNodeId = entry.getKey();
            JobRequest request = new JobRequest(this.jobId, txnCtx.sessionSettings(), localNodeId, entry.getValue(), this.enableProfiling);
            if (this.hasDirectResponse) {
                this.transportJobAction.execute(serverNodeId, request, BucketForwarder.asActionListener(pageBucketReceivers, bucketIdx, initializationTracker));
            } else {
                this.transportJobAction.execute(serverNodeId, request, new FailureOnlyResponseListener(handlerPhases, initializationTracker));
            }
            ++bucketIdx;
        }
    }

    private List<PageBucketReceiver> getHandlerBucketReceivers(RootTask rootTask, List<Tuple<ExecutionPhase, RowConsumer>> handlerPhases) {
        ArrayList<PageBucketReceiver> pageBucketReceivers = new ArrayList<PageBucketReceiver>(handlerPhases.size());
        for (Tuple<ExecutionPhase, RowConsumer> handlerPhase : handlerPhases) {
            Object ctx = rootTask.getTaskOrNull(handlerPhase.v1().phaseId());
            if (!(ctx instanceof DownstreamRXTask)) continue;
            PageBucketReceiver pageBucketReceiver = ((DownstreamRXTask)ctx).getBucketReceiver((byte)0);
            pageBucketReceivers.add(pageBucketReceiver);
        }
        return pageBucketReceivers;
    }
}

