/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.auth.user.User;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.jobs.kill.KillJobsRequest;
import io.crate.execution.jobs.kill.TransportKillJobsNodeAction;
import io.crate.execution.support.ThreadPools;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;

class InterceptingRowConsumer
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(InterceptingRowConsumer.class);
    private final AtomicInteger consumerInvokedAndJobInitialized = new AtomicInteger(2);
    private final UUID jobId;
    private final RowConsumer consumer;
    private final Executor executor;
    private final TransportKillJobsNodeAction transportKillJobsNodeAction;
    private final AtomicBoolean consumerAccepted = new AtomicBoolean(false);
    private Throwable failure = null;
    private BatchIterator<Row> iterator = null;

    InterceptingRowConsumer(UUID jobId, RowConsumer consumer, InitializationTracker jobsInitialized, Executor executor, TransportKillJobsNodeAction transportKillJobsNodeAction) {
        this.jobId = jobId;
        this.consumer = consumer;
        this.executor = executor;
        this.transportKillJobsNodeAction = transportKillJobsNodeAction;
        jobsInitialized.future.whenComplete((o, f) -> this.tryForwardResult((Throwable)f));
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (this.consumerAccepted.compareAndSet(false, true)) {
            this.iterator = iterator;
            this.tryForwardResult(failure);
        }
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.consumer.completionFuture();
    }

    private void tryForwardResult(Throwable throwable) {
        if (throwable != null && (this.failure == null || this.failure instanceof InterruptedException)) {
            this.failure = SQLExceptions.unwrap(throwable);
        }
        if (this.consumerInvokedAndJobInitialized.decrementAndGet() > 0) {
            return;
        }
        if (this.failure == null) {
            assert (this.iterator != null) : "iterator must be present";
            ThreadPools.forceExecute(this.executor, () -> this.consumer.accept(this.iterator, null));
        } else {
            this.consumer.accept(null, this.failure);
            KillJobsRequest killRequest = new KillJobsRequest(List.of(this.jobId), User.CRATE_USER.name(), "An error was encountered: " + this.failure);
            this.transportKillJobsNodeAction.broadcast(killRequest, (ActionListener)new ActionListener<Long>(){

                @Override
                public void onResponse(Long numKilled) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Killed {} contexts for jobId={} forwarding the failure={}", (Object)numKilled, (Object)InterceptingRowConsumer.this.jobId, (Object)InterceptingRowConsumer.this.failure);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Failed to kill jobId={}, forwarding failure={} anyway", (Object)InterceptingRowConsumer.this.jobId, (Object)InterceptingRowConsumer.this.failure);
                    }
                }
            });
        }
    }

    public String toString() {
        return "InterceptingBatchConsumer{consumerInvokedAndJobInitialized=" + this.consumerInvokedAndJobInitialized + ", jobId=" + this.jobId + ", consumer=" + this.consumer + ", rowReceiverDone=" + this.consumerAccepted + ", failure=" + this.failure + "}";
    }
}

