/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

class InitializationTracker {
    final CompletableFuture<Void> future = new CompletableFuture();
    private final AtomicInteger serverToInitialize;
    private volatile Throwable failure;

    InitializationTracker(int numServer) {
        if (numServer == 0) {
            this.future.complete(null);
        }
        this.serverToInitialize = new AtomicInteger(numServer);
    }

    void jobInitialized() {
        if (this.serverToInitialize.decrementAndGet() <= 0) {
            if (this.failure == null) {
                this.future.complete(null);
            } else {
                this.future.completeExceptionally(this.failure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobInitializationFailed(Throwable t) {
        InitializationTracker initializationTracker = this;
        synchronized (initializationTracker) {
            if (this.failure == null || this.failure instanceof InterruptedException) {
                this.failure = t;
            }
        }
        this.jobInitialized();
    }
}

