/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.CollectingRowConsumer;
import io.crate.data.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class FirstColumnConsumers {
    public static CollectingRowConsumer<Object[], Object> createSingleRowConsumer() {
        return new CollectingRowConsumer<Object[], Object>(SingleValue.INSTANCE);
    }

    public static CollectingRowConsumer<Collection<Object>, Object[]> createAllRowsConsumer() {
        return new CollectingRowConsumer<Collection<Object>, Object[]>(AllValues.INSTANCE);
    }

    private static class SingleValue
    implements Collector<Row, Object[], Object> {
        private static final SingleValue INSTANCE = new SingleValue();
        private static final Object SENTINEL = new Object();

        private SingleValue() {
        }

        @Override
        public Supplier<Object[]> supplier() {
            return () -> new Object[]{SENTINEL};
        }

        @Override
        public BiConsumer<Object[], Row> accumulator() {
            return (agg, row) -> {
                if (agg[0] != SENTINEL) {
                    throw new UnsupportedOperationException("Subquery returned more than 1 row when it shouldn't.");
                }
                agg[0] = row.get(0);
            };
        }

        @Override
        public BinaryOperator<Object[]> combiner() {
            throw new IllegalStateException("Combine is not implemented on this collector");
        }

        @Override
        public Function<Object[], Object> finisher() {
            return agg -> {
                if (agg[0] == SENTINEL) {
                    return null;
                }
                return agg[0];
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private static class AllValues
    implements Collector<Row, Collection<Object>, Object[]> {
        private static final AllValues INSTANCE = new AllValues();

        private AllValues() {
        }

        @Override
        public Supplier<Collection<Object>> supplier() {
            return () -> new ArrayList(1);
        }

        @Override
        public BiConsumer<Collection<Object>, Row> accumulator() {
            return (agg, row) -> agg.add(row.get(0));
        }

        @Override
        public BinaryOperator<Collection<Object>> combiner() {
            throw new IllegalStateException("Combine is not implemented on this collector");
        }

        @Override
        public Function<Collection<Object>, Object[]> finisher() {
            return Collection::toArray;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

