/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.common.collections.Tuple;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.jobs.transport.JobResponse;
import java.util.List;
import org.elasticsearch.action.ActionListener;

class FailureOnlyResponseListener
implements ActionListener<JobResponse> {
    private final List<Tuple<ExecutionPhase, RowConsumer>> consumers;
    private final InitializationTracker initializationTracker;

    FailureOnlyResponseListener(List<Tuple<ExecutionPhase, RowConsumer>> consumers, InitializationTracker initializationTracker) {
        this.consumers = consumers;
        this.initializationTracker = initializationTracker;
    }

    @Override
    public void onResponse(JobResponse jobResponse) {
        this.initializationTracker.jobInitialized();
        if (jobResponse.hasDirectResponses()) {
            for (Tuple<ExecutionPhase, RowConsumer> consumer : this.consumers) {
                consumer.v2().accept(null, new IllegalStateException("Got a directResponse but didn't expect one"));
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.initializationTracker.jobInitializationFailed(e);
        for (Tuple<ExecutionPhase, RowConsumer> consumer : this.consumers) {
            consumer.v2().accept(null, e);
        }
    }
}

