/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection.builder;

import io.crate.analyze.OrderBy;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.execution.dsl.projection.builder.SplitPoints;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.FunctionType;
import io.crate.planner.operators.LogicalPlanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

public final class SplitPointsBuilder
extends DefaultTraversalSymbolVisitor<Context, Void> {
    private static final SplitPointsBuilder INSTANCE = new SplitPointsBuilder();

    private void process(Collection<Symbol> symbols, Context context) {
        for (Symbol symbol : symbols) {
            context.foundAggregateOrTableFunction = false;
            symbol.accept(this, context);
            if (context.foundAggregateOrTableFunction) continue;
            context.standalone.add(symbol);
        }
    }

    public static SplitPoints create(QueriedSelectRelation relation) {
        Symbol having;
        Context context = new Context();
        INSTANCE.process(relation.outputs(), context);
        OrderBy orderBy = relation.orderBy();
        if (orderBy != null) {
            INSTANCE.process(orderBy.orderBySymbols(), context);
        }
        if ((having = relation.having()) != null) {
            having.accept(INSTANCE, context);
        }
        LinkedHashSet<Symbol> toCollect = new LinkedHashSet<Symbol>();
        for (Function tableFunction : context.tableFunctions) {
            toCollect.addAll(LogicalPlanner.extractColumns(tableFunction.arguments()));
        }
        for (Function aggregate : context.aggregates) {
            toCollect.addAll(aggregate.arguments());
            if (aggregate.filter() == null) continue;
            toCollect.add(aggregate.filter());
        }
        for (WindowFunction windowFunction : context.windowFunctions) {
            toCollect.addAll(LogicalPlanner.extractColumns(windowFunction.arguments()));
            if (windowFunction.filter() != null) {
                toCollect.add(windowFunction.filter());
            }
            INSTANCE.process(windowFunction.windowDefinition().partitions(), context);
            OrderBy windowOrderBy = windowFunction.windowDefinition().orderBy();
            if (windowOrderBy == null) continue;
            INSTANCE.process(windowOrderBy.orderBySymbols(), context);
        }
        Context groupByContext = new Context();
        if (!relation.groupBy().isEmpty()) {
            INSTANCE.process(relation.groupBy(), groupByContext);
            for (Function tableFunction : groupByContext.tableFunctions) {
                toCollect.addAll(LogicalPlanner.extractColumns(tableFunction.arguments()));
            }
            toCollect.addAll(groupByContext.standalone);
            context.tableFunctions.removeAll(groupByContext.tableFunctions);
        } else if (context.aggregates.isEmpty() && relation.groupBy().isEmpty()) {
            toCollect.addAll(context.standalone);
        }
        return new SplitPoints(new ArrayList<Symbol>(toCollect), context.aggregates, context.tableFunctions, groupByContext.tableFunctions, context.windowFunctions);
    }

    @Override
    public Void visitFunction(Function function, Context context) {
        FunctionType type = function.type();
        switch (type) {
            case SCALAR: {
                super.visitFunction(function, context);
                return null;
            }
            case AGGREGATE: {
                context.foundAggregateOrTableFunction = true;
                context.allocateAggregate(function);
                context.insideAggregate = true;
                super.visitFunction(function, context);
                context.insideAggregate = false;
                return null;
            }
            case TABLE: {
                if (context.insideAggregate) {
                    throw new UnsupportedOperationException("Cannot use table functions inside aggregates");
                }
                context.foundAggregateOrTableFunction = true;
                if (context.tableFunctionLevel == 0) {
                    context.allocateTableFunction(function);
                }
                ++context.tableFunctionLevel;
                super.visitFunction(function, context);
                --context.tableFunctionLevel;
                return null;
            }
        }
        throw new UnsupportedOperationException("Invalid function type: " + type);
    }

    @Override
    public Void visitWindowFunction(WindowFunction windowFunction, Context context) {
        context.foundAggregateOrTableFunction = true;
        context.allocateWindowFunction(windowFunction);
        return (Void)super.visitFunction(windowFunction, context);
    }

    @Override
    public Void visitAggregation(Aggregation symbol, Context context) {
        throw new AssertionError((Object)("Aggregation Symbols must not be visited with " + this.getClass().getCanonicalName()));
    }

    static class Context {
        private final ArrayList<Function> aggregates = new ArrayList();
        private final ArrayList<Function> tableFunctions = new ArrayList();
        private final ArrayList<Symbol> standalone = new ArrayList();
        private final ArrayList<WindowFunction> windowFunctions = new ArrayList();
        private boolean insideAggregate = false;
        private int tableFunctionLevel = 0;
        boolean foundAggregateOrTableFunction = false;

        Context() {
        }

        void allocateTableFunction(Function tableFunction) {
            if (!this.tableFunctions.contains(tableFunction)) {
                this.tableFunctions.add(tableFunction);
            }
        }

        void allocateAggregate(Function aggregate) {
            if (!this.aggregates.contains(aggregate)) {
                this.aggregates.add(aggregate);
            }
        }

        void allocateWindowFunction(WindowFunction windowFunction) {
            if (!this.windowFunctions.contains(windowFunction)) {
                this.windowFunctions.add(windowFunction);
            }
        }
    }
}

