/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection.builder;

import io.crate.common.collections.Lists2;
import io.crate.execution.dsl.projection.AggregationProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.FilterProjection;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.TopNProjection;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionInfo;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SearchPath;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ProjectionBuilder {
    private final NodeContext nodeCtx;

    public ProjectionBuilder(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AggregationProjection aggregationProjection(Collection<? extends Symbol> inputs, Collection<Function> aggregates, java.util.function.Function<Symbol, Symbol> subQueryAndParamBinder, AggregateMode mode, RowGranularity granularity, SearchPath searchPath) {
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(inputs);
        ArrayList<Aggregation> aggregations = this.getAggregations(aggregates, mode, sourceSymbols, searchPath, subQueryAndParamBinder);
        return new AggregationProjection(aggregations, granularity, mode);
    }

    public GroupProjection groupProjection(Collection<? extends Symbol> inputs, Collection<? extends Symbol> keys, Collection<Function> values, java.util.function.Function<Symbol, Symbol> subQueryAndParamBinder, AggregateMode mode, RowGranularity requiredGranularity, SearchPath searchPath) {
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(inputs);
        ArrayList<Aggregation> aggregations = this.getAggregations(values, mode, sourceSymbols, searchPath, subQueryAndParamBinder);
        return new GroupProjection(Lists2.map(InputColumns.create(keys, sourceSymbols), subQueryAndParamBinder), aggregations, mode, requiredGranularity);
    }

    private ArrayList<Aggregation> getAggregations(Collection<Function> functions, AggregateMode mode, InputColumns.SourceSymbols sourceSymbols, SearchPath searchPath, java.util.function.Function<Symbol, Symbol> subQueryAndParamBinder) {
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>(functions.size());
        for (Function function : functions) {
            List<Symbol> aggregationInputs;
            assert (function.type() == FunctionType.AGGREGATE) : "function type must be " + FunctionType.AGGREGATE;
            Symbol filterInput = switch (mode) {
                case AggregateMode.ITER_FINAL, AggregateMode.ITER_PARTIAL -> {
                    aggregationInputs = InputColumns.create(function.arguments(), sourceSymbols);
                    Symbol filter = function.filter();
                    if (filter != null) {
                        yield InputColumns.create(filter, sourceSymbols);
                    }
                    yield Literal.BOOLEAN_TRUE;
                }
                case AggregateMode.PARTIAL_FINAL -> {
                    aggregationInputs = List.of(sourceSymbols.getICForSource(function));
                    yield Literal.BOOLEAN_TRUE;
                }
                default -> throw new AssertionError((Object)("Invalid mode: " + mode.name()));
            };
            AggregationFunction aggregationFunction = (AggregationFunction)this.nodeCtx.functions().getQualified(function, searchPath);
            assert (aggregationFunction != null) : "Aggregation function implementation not found using full qualified lookup: " + function;
            DataType<?> valueType = mode.returnType(aggregationFunction);
            FunctionInfo functionInfo = FunctionInfo.of(aggregationFunction.signature(), aggregationFunction.boundSignature().getArgumentDataTypes(), valueType);
            Aggregation aggregation = new Aggregation(aggregationFunction.signature(), functionInfo, aggregationFunction.boundSignature().getReturnType().createType(), valueType, Lists2.map(aggregationInputs, subQueryAndParamBinder), subQueryAndParamBinder.apply(filterInput));
            aggregations.add(aggregation);
        }
        return aggregations;
    }

    public static FilterProjection filterProjection(Collection<? extends Symbol> inputs, Symbol query) {
        return new FilterProjection(InputColumns.create(query, inputs), InputColumn.mapToInputColumns(inputs));
    }

    @Nullable
    public static Projection topNOrEvalIfNeeded(Integer limit, int offset, int numOutputs, List<DataType<?>> inputTypes) {
        if (limit == null) {
            limit = -1;
        }
        int numInputTypes = inputTypes.size();
        List<DataType<?>> strippedInputs = inputTypes;
        if (numOutputs < numInputTypes) {
            strippedInputs = inputTypes.subList(0, numOutputs);
        }
        if (limit == -1 && offset == 0) {
            if (numOutputs >= numInputTypes) {
                return null;
            }
            return new EvalProjection(InputColumn.mapToInputColumns(strippedInputs));
        }
        return new TopNProjection(limit, offset, strippedInputs);
    }

    public static WriterProjection writerProjection(Collection<? extends Symbol> inputs, Symbol uri, @Nullable WriterProjection.CompressionType compressionType, Map<ColumnIdent, Symbol> overwrites, @Nullable List<String> outputNames, WriterProjection.OutputFormat outputFormat) {
        return new WriterProjection(InputColumn.mapToInputColumns(inputs), uri, compressionType, overwrites, outputNames, outputFormat);
    }
}

