/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection.builder;

import io.crate.common.collections.Lists2;
import io.crate.expression.scalar.SubscriptObjectFunction;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.FetchReference;
import io.crate.expression.symbol.FetchStub;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public final class InputColumns
extends DefaultTraversalSymbolVisitor<SourceSymbols, Symbol> {
    private static final InputColumns INSTANCE = new InputColumns();

    public static Symbol create(Symbol symbolTree, Collection<? extends Symbol> inputSymbols) {
        return InputColumns.create(symbolTree, new SourceSymbols(inputSymbols));
    }

    public static Symbol create(Symbol symbolTree, SourceSymbols sourceSymbols) {
        return symbolTree.accept(INSTANCE, sourceSymbols);
    }

    public static List<Symbol> create(Collection<? extends Symbol> symbols, SourceSymbols sourceSymbols) {
        ArrayList<Symbol> result = new ArrayList<Symbol>(symbols.size());
        for (Symbol symbol : symbols) {
            result.add(symbol.accept(INSTANCE, sourceSymbols));
        }
        return result;
    }

    @Override
    public Symbol visitFunction(Function symbol, SourceSymbols sourceSymbols) {
        Symbol replacement = InputColumns.getFunctionReplacementOrNull(symbol, sourceSymbols);
        if (replacement != null) {
            return replacement;
        }
        ArrayList<Symbol> replacedFunctionArgs = this.getProcessedArgs(symbol.arguments(), sourceSymbols);
        return new Function(symbol.signature(), replacedFunctionArgs, symbol.valueType());
    }

    @Nullable
    private static Symbol getFunctionReplacementOrNull(Function symbol, SourceSymbols sourceSymbols) {
        if (symbol.isDeterministic()) {
            return sourceSymbols.inputs.get(symbol);
        }
        return sourceSymbols.nonDeterministicFunctions.get(symbol);
    }

    private ArrayList<Symbol> getProcessedArgs(List<Symbol> arguments, SourceSymbols sourceSymbols) {
        ArrayList<Symbol> args = new ArrayList<Symbol>(arguments.size());
        for (Symbol arg : arguments) {
            args.add(arg.accept(this, sourceSymbols));
        }
        return args;
    }

    @Override
    public Symbol visitWindowFunction(WindowFunction windowFunction, SourceSymbols sourceSymbols) {
        Symbol functionFromSource = InputColumns.getFunctionReplacementOrNull(windowFunction, sourceSymbols);
        if (functionFromSource != null) {
            return functionFromSource;
        }
        ArrayList<Symbol> replacedFunctionArgs = this.getProcessedArgs(windowFunction.arguments(), sourceSymbols);
        Symbol filter = windowFunction.filter();
        Symbol filterWithReplacedArgs = filter != null ? filter.accept(this, sourceSymbols) : null;
        return new WindowFunction(windowFunction.signature(), replacedFunctionArgs, windowFunction.valueType(), filterWithReplacedArgs, windowFunction.windowDefinition().map(x -> x.accept(this, sourceSymbols)));
    }

    @Override
    protected Symbol visitSymbol(Symbol symbol, SourceSymbols sourceSymbols) {
        InputColumn inputColumn = sourceSymbols.inputs.get(symbol);
        if (inputColumn == null) {
            throw new IllegalArgumentException("Couldn't find " + symbol + " in " + sourceSymbols);
        }
        return inputColumn;
    }

    @Override
    public Symbol visitAlias(AliasSymbol aliasSymbol, SourceSymbols sourceSymbols) {
        InputColumn inputColumn = sourceSymbols.inputs.get(aliasSymbol);
        if (inputColumn == null) {
            Symbol column = aliasSymbol.symbol().accept(this, sourceSymbols);
            if (column == null) {
                throw new IllegalArgumentException("Couldn't find " + aliasSymbol + " in " + sourceSymbols);
            }
            return column;
        }
        return inputColumn;
    }

    @Override
    public Symbol visitLiteral(Literal symbol, SourceSymbols context) {
        return symbol;
    }

    @Override
    public Symbol visitReference(Reference ref, SourceSymbols sourceSymbols) {
        if (ref instanceof GeneratedReference) {
            return Objects.requireNonNullElse((Symbol)sourceSymbols.inputs.get(ref), ((GeneratedReference)ref).generatedExpression().accept(this, sourceSymbols));
        }
        InputColumn inputColumn = sourceSymbols.inputs.get(ref);
        if (inputColumn == null) {
            Symbol subscriptOnRoot = InputColumns.tryCreateSubscriptOnRoot(ref, ref.column(), sourceSymbols.inputs);
            if (subscriptOnRoot == null) {
                return ref;
            }
            return subscriptOnRoot;
        }
        return inputColumn;
    }

    @Override
    public Symbol visitField(ScopedSymbol field, SourceSymbols sourceSymbols) {
        InputColumn inputColumn = sourceSymbols.inputs.get(field);
        if (inputColumn == null) {
            Symbol subscriptOnRoot = InputColumns.tryCreateSubscriptOnRoot(field, field.column(), sourceSymbols.inputs);
            if (subscriptOnRoot == null) {
                throw new IllegalArgumentException("Couldn't find " + field + " in " + sourceSymbols);
            }
            return subscriptOnRoot;
        }
        return inputColumn;
    }

    @Override
    public Symbol visitFetchMarker(FetchMarker fetchMarker, SourceSymbols sourceSymbols) {
        InputColumn inputColumn = sourceSymbols.inputs.get(fetchMarker);
        if (inputColumn == null) {
            return fetchMarker.fetchId().accept(this, sourceSymbols);
        }
        return inputColumn;
    }

    @Override
    public Symbol visitFetchStub(FetchStub fetchStub, SourceSymbols sourceSymbols) {
        FetchMarker fetchMarker = fetchStub.fetchMarker();
        InputColumn fetchId = sourceSymbols.inputs.get(fetchMarker);
        if (fetchId == null) {
            throw new IllegalArgumentException("Could not find fetchMarker " + fetchMarker + " in sources: " + sourceSymbols);
        }
        return new FetchReference(fetchId, fetchStub.ref());
    }

    @Nullable
    private static Symbol tryCreateSubscriptOnRoot(Symbol symbol, ColumnIdent column, HashMap<Symbol, InputColumn> inputs) {
        if (column.isTopLevel()) {
            return null;
        }
        ColumnIdent root = column.getRoot();
        InputColumn rootIC = Symbols.lookupValueByColumn(inputs, root);
        if (rootIC == null) {
            return symbol;
        }
        DataType<?> returnType = symbol.valueType();
        List<String> path = column.path();
        List<Symbol> arguments = Lists2.mapTail(rootIC, path, Literal::of);
        return new Function(SubscriptObjectFunction.SIGNATURE, arguments, returnType);
    }

    @Override
    public Symbol visitFetchReference(FetchReference fetchReference, SourceSymbols sourceSymbols) {
        throw new AssertionError((Object)("FetchReference symbols must not be visited with " + this.getClass().getSimpleName()));
    }

    @Override
    public Symbol visitMatchPredicate(MatchPredicate matchPredicate, SourceSymbols context) {
        throw new UnsupportedOperationException("A match predicate can only be evaluated if it can be linked to a single relation.Using constructs like `match(r1.c) OR match(r2.c)` is not supported.");
    }

    @Override
    public Symbol visitAggregation(Aggregation symbol, SourceSymbols sourceSymbols) {
        throw new AssertionError((Object)("Aggregation Symbols must not be visited with " + this.getClass().getCanonicalName()));
    }

    @Override
    public Symbol visitParameterSymbol(ParameterSymbol parameterSymbol, SourceSymbols sourceSymbols) {
        return parameterSymbol;
    }

    @Override
    public Symbol visitSelectSymbol(SelectSymbol selectSymbol, SourceSymbols sourceSymbols) {
        return selectSymbol;
    }

    public static class SourceSymbols {
        private final HashMap<Symbol, InputColumn> inputs;
        final IdentityHashMap<Symbol, InputColumn> nonDeterministicFunctions;

        public SourceSymbols(Collection<? extends Symbol> inputs) {
            this.inputs = new HashMap(inputs.size());
            this.nonDeterministicFunctions = new IdentityHashMap(inputs.size());
            int i = 0;
            for (Symbol symbol : inputs) {
                this.add(i, symbol);
                if (symbol instanceof AliasSymbol) {
                    this.add(i, ((AliasSymbol)symbol).symbol());
                }
                ++i;
            }
        }

        public void add(int i, Symbol input) {
            SymbolType symbolType = input.symbolType();
            if (!symbolType.isValueSymbol()) {
                DataType<?> valueType = input.valueType();
                if (!(symbolType != SymbolType.FUNCTION && symbolType != SymbolType.WINDOW_FUNCTION || ((Function)input).isDeterministic())) {
                    this.nonDeterministicFunctions.put(input, new InputColumn(i, valueType));
                } else {
                    this.inputs.put(input, new InputColumn(i, valueType));
                }
            }
        }

        public InputColumn getICForSource(Symbol source) {
            InputColumn inputColumn = this.inputs.get(source);
            if (inputColumn == null) {
                throw new IllegalArgumentException("source " + source + " isn't present in the source symbols: " + this.inputs.keySet());
            }
            return inputColumn;
        }

        public String toString() {
            return "SourceSymbols{inputs=" + this.inputs + ", nonDeterministicFunctions=" + this.nonDeterministicFunctions + "}";
        }
    }
}

