/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UpdateProjection
extends Projection {
    final Symbol uidSymbol;
    private Symbol[] assignments;
    private String[] assignmentsColumns;
    private Symbol[] outputs;
    @Nullable
    private Symbol[] returnValues;
    @Nullable
    private Long requiredVersion;

    public UpdateProjection(Symbol uidSymbol, String[] assignmentsColumns, Symbol[] assignments, Symbol[] outputs, @Nullable Symbol[] returnValues, @Nullable Long requiredVersion) {
        this.uidSymbol = uidSymbol;
        this.assignmentsColumns = assignmentsColumns;
        this.assignments = assignments;
        this.returnValues = returnValues;
        assert (Arrays.stream(outputs).noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "Cannot operate on Reference, Field or SelectSymbol symbols: " + outputs;
        this.outputs = outputs;
        this.requiredVersion = requiredVersion;
    }

    public UpdateProjection(StreamInput in) throws IOException {
        this.uidSymbol = Symbols.fromStream(in);
        int assignmentColumnsSize = in.readVInt();
        this.assignmentsColumns = new String[assignmentColumnsSize];
        for (int i = 0; i < assignmentColumnsSize; ++i) {
            this.assignmentsColumns[i] = in.readString();
        }
        int assignmentsSize = in.readVInt();
        this.assignments = new Symbol[assignmentsSize];
        for (int i = 0; i < assignmentsSize; ++i) {
            this.assignments[i] = Symbols.fromStream(in);
        }
        this.requiredVersion = in.readVLong();
        if (this.requiredVersion == 0L) {
            this.requiredVersion = null;
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0)) {
            int outputSize = in.readVInt();
            this.outputs = new Symbol[outputSize];
            for (int i = 0; i < outputSize; ++i) {
                this.outputs[i] = Symbols.fromStream(in);
            }
            int returnValuesSize = in.readVInt();
            if (returnValuesSize > 0) {
                this.returnValues = new Symbol[returnValuesSize];
                for (int i = 0; i < returnValuesSize; ++i) {
                    this.returnValues[i] = Symbols.fromStream(in);
                }
            }
        } else {
            this.outputs = new Symbol[]{new InputColumn(0, DataTypes.LONG)};
        }
    }

    public Symbol uidSymbol() {
        return this.uidSymbol;
    }

    @Nullable
    public Symbol[] returnValues() {
        return this.returnValues;
    }

    public String[] assignmentsColumns() {
        return this.assignmentsColumns;
    }

    public Symbol[] assignments() {
        return this.assignments;
    }

    @Nullable
    public Long requiredVersion() {
        return this.requiredVersion;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.UPDATE;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitUpdateProjection(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return List.of(this.outputs);
    }

    @Override
    public RowGranularity requiredGranularity() {
        return RowGranularity.SHARD;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateProjection that = (UpdateProjection)o;
        if (!Arrays.equals(this.assignments, that.assignments)) {
            return false;
        }
        if (!Arrays.equals(this.assignmentsColumns, that.assignmentsColumns)) {
            return false;
        }
        if (this.requiredVersion != null ? !this.requiredVersion.equals(that.requiredVersion) : that.requiredVersion != null) {
            return false;
        }
        if (!this.uidSymbol.equals(that.uidSymbol)) {
            return false;
        }
        if (!Arrays.equals(this.returnValues, that.returnValues)) {
            return false;
        }
        return Arrays.equals(this.outputs, that.outputs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.assignments);
        result = 31 * result + Arrays.hashCode(this.assignmentsColumns);
        result = 31 * result + (this.requiredVersion != null ? this.requiredVersion.hashCode() : 0);
        result = 31 * result + this.uidSymbol.hashCode();
        result = 31 * result + Arrays.hashCode(this.returnValues);
        result = 31 * result + Arrays.hashCode(this.outputs);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        int i;
        Symbols.toStream(this.uidSymbol, out);
        out.writeVInt(this.assignmentsColumns.length);
        for (i = 0; i < this.assignmentsColumns.length; ++i) {
            out.writeString(this.assignmentsColumns[i]);
        }
        out.writeVInt(this.assignments.length);
        for (i = 0; i < this.assignments.length; ++i) {
            Symbols.toStream(this.assignments[i], out);
        }
        if (this.requiredVersion == null) {
            out.writeVLong(0L);
        } else {
            out.writeVLong(this.requiredVersion);
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeVInt(this.outputs.length);
            for (i = 0; i < this.outputs.length; ++i) {
                Symbols.toStream(this.outputs[i], out);
            }
            if (this.returnValues != null) {
                out.writeVInt(this.returnValues.length);
                for (i = 0; i < this.returnValues.length; ++i) {
                    Symbols.toStream(this.returnValues[i], out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }
}

