/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.Lists2;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class TopNProjection
extends Projection {
    private final int limit;
    private final int offset;
    private final List<Symbol> outputs;

    public TopNProjection(int limit, int offset, List<DataType<?>> outputTypes) {
        assert (limit > -1) : "limit of TopNProjection must not be negative/unlimited";
        this.limit = limit;
        this.offset = offset;
        this.outputs = InputColumn.mapToInputColumns(outputTypes);
    }

    public TopNProjection(StreamInput in) throws IOException {
        this.offset = in.readVInt();
        this.limit = in.readVInt();
        this.outputs = Symbols.listFromStream(in);
    }

    public List<Symbol> outputs() {
        return this.outputs;
    }

    public int limit() {
        return this.limit;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.TOPN;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitTopNProjection(this, context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.offset);
        out.writeVInt(this.limit);
        Symbols.toStream(this.outputs, out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNProjection that = (TopNProjection)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        return this.outputs.equals(that.outputs);
    }

    @Override
    public int hashCode() {
        int result = this.limit;
        result = 31 * result + this.offset;
        result = 31 * result + this.outputs.hashCode();
        return result;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put("type", "TopN").put("limit", (String)((Object)Integer.valueOf(this.limit))).put("offset", (String)((Object)Integer.valueOf(this.offset))).put("outputs", Lists2.joinOn(", ", this.outputs, Symbol::toString)).map();
    }

    public String toString() {
        return "TopNProjection{outputs=" + this.outputs + ", limit=" + this.limit + ", offset=" + this.offset + "}";
    }
}

