/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SysUpdateProjection
extends Projection {
    private final Symbol uidSymbol;
    private Map<Reference, Symbol> assignments;
    private Symbol[] outputs;
    @Nullable
    private Symbol[] returnValues;

    public SysUpdateProjection(Symbol uidSymbol, Map<Reference, Symbol> assignments, Symbol[] outputs, @Nullable Symbol[] returnValues) {
        this.uidSymbol = uidSymbol;
        this.assignments = assignments;
        this.returnValues = returnValues;
        assert (Arrays.stream(outputs).noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "Cannot operate on Reference, Field or SelectSymbol symbols: " + outputs;
        this.outputs = outputs;
    }

    public SysUpdateProjection(StreamInput in) throws IOException {
        this.uidSymbol = Symbols.fromStream(in);
        int numAssignments = in.readVInt();
        this.assignments = new HashMap<Reference, Symbol>(numAssignments, 1.0f);
        for (int i = 0; i < numAssignments; ++i) {
            this.assignments.put((Reference)Reference.fromStream(in), Symbols.fromStream(in));
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0)) {
            int outputSize = in.readVInt();
            this.outputs = new Symbol[outputSize];
            for (int i = 0; i < outputSize; ++i) {
                this.outputs[i] = Symbols.fromStream(in);
            }
            int returnValuesSize = in.readVInt();
            if (returnValuesSize > 0) {
                this.returnValues = new Symbol[returnValuesSize];
                for (int i = 0; i < returnValuesSize; ++i) {
                    this.returnValues[i] = Symbols.fromStream(in);
                }
            }
        } else {
            this.outputs = new Symbol[]{new InputColumn(0, DataTypes.LONG)};
        }
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.SYS_UPDATE;
    }

    @Nullable
    public Symbol[] returnValues() {
        return this.returnValues;
    }

    @Override
    public List<? extends Symbol> outputs() {
        return List.of(this.outputs);
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitSysUpdateProjection(this, context);
    }

    public Map<Reference, Symbol> assignments() {
        return this.assignments;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbols.toStream(this.uidSymbol, out);
        out.writeVInt(this.assignments.size());
        for (Map.Entry<Reference, Symbol> e : this.assignments.entrySet()) {
            Reference.toStream(e.getKey(), out);
            Symbols.toStream(e.getValue(), out);
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            int i;
            out.writeVInt(this.outputs.length);
            for (i = 0; i < this.outputs.length; ++i) {
                Symbols.toStream(this.outputs[i], out);
            }
            if (this.returnValues != null) {
                out.writeVInt(this.returnValues.length);
                for (i = 0; i < this.returnValues.length; ++i) {
                    Symbols.toStream(this.returnValues[i], out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SysUpdateProjection that = (SysUpdateProjection)o;
        return Objects.equals(this.uidSymbol, that.uidSymbol) && Objects.equals(this.assignments, that.assignments) && Arrays.equals(this.outputs, that.outputs) && Arrays.equals(this.returnValues, that.returnValues);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.uidSymbol, this.assignments);
        result = 31 * result + Arrays.hashCode(this.outputs);
        result = 31 * result + Arrays.hashCode(this.returnValues);
        return result;
    }

    @Override
    public RowGranularity requiredGranularity() {
        return RowGranularity.NODE;
    }
}

