/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.SourceIndexWriterProjection;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class SourceIndexWriterReturnSummaryProjection
extends SourceIndexWriterProjection {
    private final InputColumn sourceUri;
    private final InputColumn sourceUriFailure;
    private final InputColumn lineNumber;

    public SourceIndexWriterReturnSummaryProjection(RelationName relationName, @Nullable String partitionIdent, Reference rawSourceReference, InputColumn rawSourcePtr, List<ColumnIdent> primaryKeys, List<Symbol> partitionedBySymbols, @Nullable ColumnIdent clusteredByColumn, Settings settings, @Nullable String[] includes, @Nullable String[] excludes, List<Symbol> idSymbols, @Nullable Symbol clusteredBySymbol, List<? extends Symbol> outputs, boolean autoCreateIndices, InputColumn sourceUri, InputColumn sourceUriFailure, InputColumn lineNumber) {
        super(relationName, partitionIdent, rawSourceReference, rawSourcePtr, primaryKeys, partitionedBySymbols, clusteredByColumn, settings, includes, excludes, idSymbols, clusteredBySymbol, outputs, autoCreateIndices);
        this.sourceUri = sourceUri;
        this.sourceUriFailure = sourceUriFailure;
        this.lineNumber = lineNumber;
    }

    SourceIndexWriterReturnSummaryProjection(StreamInput in) throws IOException {
        super(in);
        this.sourceUri = (InputColumn)Symbols.fromStream(in);
        this.sourceUriFailure = (InputColumn)Symbols.fromStream(in);
        this.lineNumber = (InputColumn)Symbols.fromStream(in);
    }

    public InputColumn sourceUri() {
        return this.sourceUri;
    }

    public InputColumn sourceUriFailure() {
        return this.sourceUriFailure;
    }

    public InputColumn lineNumber() {
        return this.lineNumber;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.INDEX_WRITER_RETURN_SUMMARY;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Symbols.toStream(this.sourceUri, out);
        Symbols.toStream(this.sourceUriFailure, out);
        Symbols.toStream(this.lineNumber, out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceIndexWriterReturnSummaryProjection that = (SourceIndexWriterReturnSummaryProjection)o;
        return Objects.equals(this.sourceUri, that.sourceUri) && Objects.equals(this.sourceUriFailure, that.sourceUriFailure) && Objects.equals(this.lineNumber, that.lineNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceUri, this.sourceUriFailure, this.lineNumber);
    }
}

