/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class SourceIndexWriterProjection
extends AbstractIndexWriterProjection {
    private static final String OVERWRITE_DUPLICATES = "overwrite_duplicates";
    private static final boolean OVERWRITE_DUPLICATES_DEFAULT = false;
    private final Boolean overwriteDuplicates;
    private final Reference rawSourceReference;
    private final InputColumn rawSourceSymbol;
    private final List<? extends Symbol> outputs;
    @Nullable
    private String[] includes;
    @Nullable
    private String[] excludes;

    public SourceIndexWriterProjection(RelationName relationName, @Nullable String partitionIdent, Reference rawSourceReference, InputColumn rawSourcePtr, List<ColumnIdent> primaryKeys, List<Symbol> partitionedBySymbols, @Nullable ColumnIdent clusteredByColumn, Settings settings, @Nullable String[] includes, @Nullable String[] excludes, List<Symbol> idSymbols, @Nullable Symbol clusteredBySymbol, List<? extends Symbol> outputs, boolean autoCreateIndices) {
        super(relationName, partitionIdent, primaryKeys, clusteredByColumn, settings, idSymbols, autoCreateIndices);
        this.rawSourceReference = rawSourceReference;
        this.includes = includes;
        this.excludes = excludes;
        this.partitionedBySymbols = partitionedBySymbols;
        this.clusteredBySymbol = clusteredBySymbol;
        this.rawSourceSymbol = rawSourcePtr;
        this.outputs = outputs;
        this.overwriteDuplicates = settings.getAsBoolean(OVERWRITE_DUPLICATES, false);
    }

    SourceIndexWriterProjection(StreamInput in) throws IOException {
        super(in);
        int i;
        int length;
        this.overwriteDuplicates = in.readBoolean();
        this.rawSourceReference = Reference.fromStream(in);
        this.rawSourceSymbol = (InputColumn)Symbols.fromStream(in);
        if (in.readBoolean()) {
            length = in.readVInt();
            this.includes = new String[length];
            for (i = 0; i < length; ++i) {
                this.includes[i] = in.readString();
            }
        }
        if (in.readBoolean()) {
            length = in.readVInt();
            this.excludes = new String[length];
            for (i = 0; i < length; ++i) {
                this.excludes[i] = in.readString();
            }
        }
        this.outputs = Symbols.listFromStream(in);
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitSourceIndexWriterProjection(this, context);
    }

    public InputColumn rawSource() {
        return this.rawSourceSymbol;
    }

    public Reference rawSourceReference() {
        return this.rawSourceReference;
    }

    @Nullable
    public String[] includes() {
        return this.includes;
    }

    @Nullable
    public String[] excludes() {
        return this.excludes;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.INDEX_WRITER;
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceIndexWriterProjection that = (SourceIndexWriterProjection)o;
        return Objects.equals(this.overwriteDuplicates, that.overwriteDuplicates) && Objects.equals(this.rawSourceReference, that.rawSourceReference) && Objects.equals(this.rawSourceSymbol, that.rawSourceSymbol) && Arrays.equals(this.includes, that.includes) && Arrays.equals(this.excludes, that.excludes);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.overwriteDuplicates, this.rawSourceReference, this.rawSourceSymbol);
        result = 31 * result + Arrays.hashCode(this.includes);
        result = 31 * result + Arrays.hashCode(this.excludes);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.overwriteDuplicates);
        Reference.toStream(this.rawSourceReference, out);
        Symbols.toStream(this.rawSourceSymbol, out);
        if (this.includes == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.includes.length);
            for (String include : this.includes) {
                out.writeString(include);
            }
        }
        if (this.excludes == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.excludes.length);
            for (String exclude : this.excludes) {
                out.writeString(exclude);
            }
        }
        Symbols.toStream(this.outputs, out);
    }

    public boolean overwriteDuplicates() {
        return this.overwriteDuplicates;
    }
}

