/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import com.google.common.collect.Collections2;
import io.crate.execution.dsl.projection.Projection;
import io.crate.metadata.RowGranularity;
import java.util.Collection;

public class Projections {
    public static Collection<? extends Projection> shardProjections(Collection<? extends Projection> projections) {
        return Collections2.filter(projections, Projection.IS_SHARD_PROJECTION::test);
    }

    public static Collection<? extends Projection> nodeProjections(Collection<? extends Projection> projections) {
        return Collections2.filter(projections, Projection.IS_NODE_PROJECTION::test);
    }

    public static boolean hasAnyShardProjections(Iterable<? extends Projection> projections) {
        for (Projection projection : projections) {
            if (projection.requiredGranularity() != RowGranularity.SHARD) continue;
            return true;
        }
        return false;
    }
}

