/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RowGranularity;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class Projection {
    static final Predicate<Projection> IS_SHARD_PROJECTION = p -> p.requiredGranularity() == RowGranularity.SHARD;
    static final Predicate<Projection> IS_NODE_PROJECTION = IS_SHARD_PROJECTION.negate();

    public RowGranularity requiredGranularity() {
        return RowGranularity.CLUSTER;
    }

    public abstract ProjectionType projectionType();

    public abstract <C, R> R accept(ProjectionVisitor<C, R> var1, C var2);

    public abstract List<? extends Symbol> outputs();

    public static void toStream(Projection projection, StreamOutput out) throws IOException {
        out.writeVInt(projection.projectionType().ordinal());
        projection.writeTo(out);
    }

    public static Projection fromStream(StreamInput in) throws IOException {
        return ProjectionType.values()[in.readVInt()].newInstance(in);
    }

    public abstract void writeTo(StreamOutput var1) throws IOException;

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.projectionType().hashCode();
    }

    public Map<String, Object> mapRepresentation() {
        return Map.of("type", this.projectionType().toString());
    }

    public static interface ProjectionFactory<T extends Projection> {
        public T newInstance(StreamInput var1) throws IOException;
    }
}

