/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.Lists2;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class ProjectSetProjection
extends Projection {
    private final List<Symbol> tableFunctionsWithInputs;
    private final List<Symbol> standaloneWithInputs;
    private final List<Symbol> outputs;

    public ProjectSetProjection(List<Symbol> tableFunctionsWithInputs, List<Symbol> standaloneWithInputs) {
        assert (tableFunctionsWithInputs.stream().noneMatch(Symbols.IS_COLUMN)) : "Cannot operate on Reference or Field: " + tableFunctionsWithInputs;
        assert (standaloneWithInputs.stream().noneMatch(Symbols.IS_COLUMN)) : "Cannot operate on Reference or Field: " + standaloneWithInputs;
        this.tableFunctionsWithInputs = tableFunctionsWithInputs;
        this.standaloneWithInputs = standaloneWithInputs;
        this.outputs = Lists2.concat(tableFunctionsWithInputs, standaloneWithInputs);
    }

    public ProjectSetProjection(StreamInput in) throws IOException {
        this.tableFunctionsWithInputs = Symbols.listFromStream(in);
        this.standaloneWithInputs = Symbols.listFromStream(in);
        this.outputs = Lists2.concat(this.tableFunctionsWithInputs, this.standaloneWithInputs);
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.PROJECT_SET;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitProjectSet(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbols.toStream(this.tableFunctionsWithInputs, out);
        Symbols.toStream(this.standaloneWithInputs, out);
    }

    public List<Symbol> tableFunctions() {
        return this.tableFunctionsWithInputs;
    }

    public List<Symbol> standalone() {
        return this.standaloneWithInputs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSetProjection that = (ProjectSetProjection)o;
        if (!this.tableFunctionsWithInputs.equals(that.tableFunctionsWithInputs)) {
            return false;
        }
        return this.standaloneWithInputs.equals(that.standaloneWithInputs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tableFunctionsWithInputs.hashCode();
        result = 31 * result + this.standaloneWithInputs.hashCode();
        return result;
    }
}

