/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OrderedTopNProjection
extends Projection {
    private final int limit;
    private final int offset;
    private final List<Symbol> outputs;
    private final List<Symbol> orderBy;
    private final boolean[] reverseFlags;
    private final boolean[] nullsFirst;

    public OrderedTopNProjection(int limit, int offset, List<Symbol> outputs, List<Symbol> orderBy, boolean[] reverseFlags, boolean[] nullsFirst) {
        assert (outputs.stream().noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "OrderedTopNProjection outputs cannot contain Field, Reference or SelectSymbol symbols: " + outputs;
        assert (orderBy.stream().noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "OrderedTopNProjection orderBy cannot contain Field, Reference or SelectSymbol symbols: " + orderBy;
        assert (orderBy.size() == reverseFlags.length) : "reverse flags length does not match orderBy items count";
        assert (orderBy.size() == nullsFirst.length) : "nullsFirst length does not match orderBy items count";
        this.limit = limit;
        this.offset = offset;
        this.outputs = outputs;
        this.orderBy = orderBy;
        this.reverseFlags = reverseFlags;
        this.nullsFirst = nullsFirst;
    }

    public OrderedTopNProjection(StreamInput in) throws IOException {
        this.limit = in.readVInt();
        this.offset = in.readVInt();
        this.outputs = Symbols.listFromStream(in);
        int numOrderBy = in.readVInt();
        if (numOrderBy == 0) {
            this.orderBy = Collections.emptyList();
            this.reverseFlags = new boolean[0];
            this.nullsFirst = new boolean[0];
        } else {
            this.orderBy = new ArrayList<Symbol>(numOrderBy);
            this.reverseFlags = new boolean[numOrderBy];
            this.nullsFirst = new boolean[numOrderBy];
            for (int i = 0; i < numOrderBy; ++i) {
                this.orderBy.add(Symbols.fromStream(in));
                this.reverseFlags[i] = in.readBoolean();
                this.nullsFirst[i] = in.readBoolean();
            }
        }
    }

    public List<Symbol> orderBy() {
        return this.orderBy;
    }

    public int limit() {
        return this.limit;
    }

    public int offset() {
        return this.offset;
    }

    public boolean[] reverseFlags() {
        return this.reverseFlags;
    }

    public boolean[] nullsFirst() {
        return this.nullsFirst;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.TOPN_ORDERED;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitOrderedTopN(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.limit);
        out.writeVInt(this.offset);
        Symbols.toStream(this.outputs, out);
        out.writeVInt(this.orderBy.size());
        for (int i = 0; i < this.orderBy.size(); ++i) {
            Symbols.toStream(this.orderBy.get(i), out);
            out.writeBoolean(this.reverseFlags[i]);
            out.writeBoolean(this.nullsFirst[i]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedTopNProjection that = (OrderedTopNProjection)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (!this.outputs.equals(that.outputs)) {
            return false;
        }
        if (!this.orderBy.equals(that.orderBy)) {
            return false;
        }
        if (!Arrays.equals(this.reverseFlags, that.reverseFlags)) {
            return false;
        }
        return Arrays.equals(this.nullsFirst, that.nullsFirst);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.limit;
        result = 31 * result + this.offset;
        result = 31 * result + this.outputs.hashCode();
        result = 31 * result + this.orderBy.hashCode();
        result = 31 * result + Arrays.hashCode(this.reverseFlags);
        result = 31 * result + Arrays.hashCode(this.nullsFirst);
        return result;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put("type", "OrderByTopN").put("limit", (String)((Object)Integer.valueOf(this.limit))).put("offset", (String)((Object)Integer.valueOf(this.offset))).put("outputs", Lists2.joinOn(", ", this.outputs, Symbol::toString)).put("orderBy", OrderBy.explainRepresentation(new StringBuilder("["), this.orderBy, this.reverseFlags, this.nullsFirst, Symbol::toString).append("]").toString()).map();
    }
}

