/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.Lists2;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GroupProjection
extends Projection {
    private final List<Symbol> keys;
    private final List<Aggregation> values;
    private List<Symbol> outputs;
    private final AggregateMode mode;
    private final RowGranularity requiredGranularity;

    public GroupProjection(List<Symbol> keys, List<Aggregation> values, AggregateMode mode, RowGranularity requiredGranularity) {
        assert (keys.stream().noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "Cannot operate on Reference, Field or SelectSymbol symbols: " + keys;
        assert (values.stream().noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "Cannot operate on Reference, Field or SelectSymbol symbols: " + values;
        this.keys = keys;
        this.values = values;
        this.mode = mode;
        this.requiredGranularity = requiredGranularity;
    }

    public GroupProjection(StreamInput in) throws IOException {
        this.mode = AggregateMode.readFrom(in);
        this.keys = Symbols.listFromStream(in);
        int size = in.readVInt();
        this.values = new ArrayList<Aggregation>(size);
        for (int i = 0; i < size; ++i) {
            this.values.add((Aggregation)Symbols.fromStream(in));
        }
        this.requiredGranularity = RowGranularity.fromStream(in);
    }

    public List<Symbol> keys() {
        return this.keys;
    }

    public List<Aggregation> values() {
        return this.values;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.GROUP;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitGroupProjection(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        if (this.outputs == null) {
            this.outputs = new ArrayList<Symbol>(this.keys.size() + this.values.size());
            this.outputs.addAll(this.keys);
            this.outputs.addAll(this.values);
        }
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        AggregateMode.writeTo(this.mode, out);
        Symbols.toStream(this.keys, out);
        Symbols.toStream(this.values, out);
        RowGranularity.toStream(this.requiredGranularity, out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupProjection that = (GroupProjection)o;
        return Objects.equals(this.keys, that.keys) && Objects.equals(this.values, that.values) && Objects.equals(this.outputs, that.outputs) && this.mode == that.mode && this.requiredGranularity == that.requiredGranularity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.keys, this.values, this.outputs, this.mode, this.requiredGranularity});
    }

    @Override
    public RowGranularity requiredGranularity() {
        return this.requiredGranularity;
    }

    public AggregateMode mode() {
        return this.mode;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put("type", "HashAggregation").put("keys", Lists2.joinOn(", ", this.keys, Symbol::toString)).put("aggregations", Lists2.joinOn(", ", this.values, Symbol::toString)).map();
    }
}

