/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.Streamer;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.MapBuilder;
import io.crate.data.Paging;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RelationName;
import io.crate.planner.node.fetch.FetchSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class FetchProjection
extends Projection {
    private static final int HEAP_IN_MB = (int)(JvmInfo.jvmInfo().getConfiguredMaxHeapSize() / 0x100000L);
    private static final int MAX_FETCH_SIZE = FetchProjection.maxFetchSize(HEAP_IN_MB);
    private final int fetchPhaseId;
    private final int fetchSize;
    private final Map<RelationName, FetchSource> fetchSources;
    private final List<Symbol> outputSymbols;
    private final Map<String, IntSet> nodeReaders;
    private final TreeMap<Integer, String> readerIndices;
    private final Map<String, RelationName> indicesToIdents;

    public FetchProjection(int fetchPhaseId, int suppliedFetchSize, Map<RelationName, FetchSource> fetchSources, List<Symbol> outputSymbols, Map<String, IntSet> nodeReaders, TreeMap<Integer, String> readerIndices, Map<String, RelationName> indicesToIdents) {
        assert (outputSymbols.stream().noneMatch(s -> SymbolVisitors.any(x -> x instanceof ScopedSymbol || x instanceof SelectSymbol, s))) : "Cannot operate on Field or SelectSymbol symbols: " + outputSymbols;
        this.fetchPhaseId = fetchPhaseId;
        this.fetchSources = fetchSources;
        this.outputSymbols = outputSymbols;
        this.nodeReaders = nodeReaders;
        this.readerIndices = readerIndices;
        this.indicesToIdents = indicesToIdents;
        this.fetchSize = FetchProjection.boundedFetchSize(suppliedFetchSize, MAX_FETCH_SIZE);
    }

    @VisibleForTesting
    static int maxFetchSize(int maxHeapInMb) {
        int x0 = 56;
        int y0 = 2000;
        int x1 = 256;
        int y1 = 30000;
        return Math.min(y0 + (maxHeapInMb - x0) * ((y1 - y0) / (x1 - x0)), Paging.PAGE_SIZE);
    }

    @VisibleForTesting
    static int boundedFetchSize(int suppliedFetchSize, int maxSize) {
        if (suppliedFetchSize == 0) {
            return maxSize;
        }
        return Math.min(suppliedFetchSize, maxSize);
    }

    public int fetchPhaseId() {
        return this.fetchPhaseId;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Map<RelationName, FetchSource> fetchSources() {
        return this.fetchSources;
    }

    public List<Symbol> outputSymbols() {
        return this.outputSymbols;
    }

    public Map<String, IntSet> nodeReaders() {
        return this.nodeReaders;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.FETCH;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitFetchProjection(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputSymbols;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchProjection that = (FetchProjection)o;
        return this.fetchPhaseId == that.fetchPhaseId;
    }

    @Override
    public int hashCode() {
        return this.fetchPhaseId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("writeTo is not supported for " + FetchProjection.class.getSimpleName());
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put("type", "Fetch").put("outputs", Lists2.joinOn(", ", this.outputSymbols, Symbol::toString)).put("fetchSize", (String)((Object)Integer.valueOf(this.fetchSize))).map();
    }

    public Map<String, ? extends IntObjectMap<Streamer[]>> generateStreamersGroupedByReaderAndNode() {
        HashMap<String, IntObjectHashMap> streamersByReaderByNode = new HashMap<String, IntObjectHashMap>();
        for (Map.Entry<String, IntSet> entry : this.nodeReaders.entrySet()) {
            IntObjectHashMap streamersByReaderId = new IntObjectHashMap();
            String nodeId = entry.getKey();
            streamersByReaderByNode.put(nodeId, streamersByReaderId);
            for (IntCursor readerIdCursor : entry.getValue()) {
                int readerId = readerIdCursor.value;
                String index = this.readerIndices.floorEntry(readerId).getValue();
                RelationName relationName = this.indicesToIdents.get(index);
                FetchSource fetchSource = this.fetchSources.get(relationName);
                if (fetchSource == null) continue;
                streamersByReaderId.put(readerIdCursor.value, Symbols.streamerArray(fetchSource.references()));
            }
        }
        return streamersByReaderByNode;
    }
}

