/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class ColumnIndexWriterProjection
extends AbstractIndexWriterProjection {
    private final List<Symbol> targetColsSymbolsExclPartition;
    private final List<Reference> targetColsExclPartitionCols;
    private final boolean ignoreDuplicateKeys;
    private final Map<Reference, Symbol> onDuplicateKeyAssignments;
    private final List<Reference> allTargetColumns;
    private final List<? extends Symbol> outputs;
    private List<Symbol> returnValues;

    public ColumnIndexWriterProjection(RelationName relationName, @Nullable String partitionIdent, List<ColumnIdent> primaryKeys, List<Reference> allTargetColumns, List<Reference> targetColsExclPartitionCols, List<Symbol> targetColsSymbolsExclPartition, boolean ignoreDuplicateKeys, Map<Reference, Symbol> onDuplicateKeyAssignments, List<Symbol> primaryKeySymbols, List<Symbol> partitionedBySymbols, @Nullable ColumnIdent clusteredByColumn, @Nullable Symbol clusteredBySymbol, Settings settings, boolean autoCreateIndices, List<? extends Symbol> outputs, List<Symbol> returnValues) {
        super(relationName, partitionIdent, primaryKeys, clusteredByColumn, settings, primaryKeySymbols, autoCreateIndices);
        assert (partitionedBySymbols.stream().noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN, s))) : "All references and fields in partitionedBySymbols must be resolved to inputColumns, got: " + partitionedBySymbols;
        this.allTargetColumns = allTargetColumns;
        this.partitionedBySymbols = partitionedBySymbols;
        this.ignoreDuplicateKeys = ignoreDuplicateKeys;
        this.onDuplicateKeyAssignments = onDuplicateKeyAssignments;
        this.targetColsExclPartitionCols = targetColsExclPartitionCols;
        this.clusteredBySymbol = clusteredBySymbol;
        this.targetColsSymbolsExclPartition = targetColsSymbolsExclPartition;
        this.outputs = outputs;
        this.returnValues = returnValues;
    }

    ColumnIndexWriterProjection(StreamInput in) throws IOException {
        super(in);
        int mapSize;
        int i;
        this.targetColsSymbolsExclPartition = in.readBoolean() ? Symbols.listFromStream(in) : Collections.emptyList();
        if (in.readBoolean()) {
            int length = in.readVInt();
            this.targetColsExclPartitionCols = new ArrayList<Reference>(length);
            for (i = 0; i < length; ++i) {
                this.targetColsExclPartitionCols.add((Reference)Reference.fromStream(in));
            }
        } else {
            this.targetColsExclPartitionCols = Collections.emptyList();
        }
        this.ignoreDuplicateKeys = in.readBoolean();
        if (in.readBoolean()) {
            mapSize = in.readVInt();
            this.onDuplicateKeyAssignments = new HashMap<Reference, Symbol>(mapSize);
            for (i = 0; i < mapSize; ++i) {
                this.onDuplicateKeyAssignments.put((Reference)Reference.fromStream(in), Symbols.fromStream(in));
            }
        } else {
            this.onDuplicateKeyAssignments = Collections.emptyMap();
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0)) {
            int i2;
            mapSize = in.readVInt();
            this.allTargetColumns = new ArrayList<Reference>();
            for (i = 0; i < mapSize; ++i) {
                this.allTargetColumns.add((Reference)Reference.fromStream(in));
            }
            int outputSize = in.readVInt();
            if (outputSize > 0) {
                ArrayList<? extends Symbol> result = new ArrayList<Symbol>(outputSize);
                for (i2 = 0; i2 < outputSize; ++i2) {
                    result.add(Symbols.fromStream(in));
                }
                this.outputs = result;
            } else {
                this.outputs = List.of();
            }
            int returnValueSize = in.readVInt();
            if (returnValueSize > 0) {
                this.returnValues = new ArrayList<Symbol>(returnValueSize);
                for (i2 = 0; i2 < returnValueSize; ++i2) {
                    this.returnValues.add(Symbols.fromStream(in));
                }
            } else {
                this.returnValues = List.of();
            }
        } else {
            this.returnValues = List.of();
            this.outputs = List.of();
            this.allTargetColumns = List.of();
        }
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    public List<Symbol> returnValues() {
        return this.returnValues;
    }

    public List<Reference> allTargetColumns() {
        return this.allTargetColumns;
    }

    public List<Symbol> columnSymbolsExclPartition() {
        return this.targetColsSymbolsExclPartition;
    }

    public List<Reference> columnReferencesExclPartition() {
        return this.targetColsExclPartitionCols;
    }

    public boolean isIgnoreDuplicateKeys() {
        return this.ignoreDuplicateKeys;
    }

    public Map<Reference, Symbol> onDuplicateKeyAssignments() {
        return this.onDuplicateKeyAssignments;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitColumnIndexWriterProjection(this, context);
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.COLUMN_INDEX_WRITER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColumnIndexWriterProjection that = (ColumnIndexWriterProjection)o;
        return this.targetColsSymbolsExclPartition.equals(that.targetColsSymbolsExclPartition) && this.targetColsExclPartitionCols.equals(that.targetColsExclPartitionCols) && this.onDuplicateKeyAssignments.equals(that.onDuplicateKeyAssignments) && this.allTargetColumns.equals(that.allTargetColumns) && Objects.equals(this.outputs, that.outputs) && Objects.equals(this.returnValues, that.returnValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetColsSymbolsExclPartition, this.targetColsExclPartitionCols, this.onDuplicateKeyAssignments, this.allTargetColumns, this.outputs, this.returnValues);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.targetColsSymbolsExclPartition == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Symbols.toStream(this.targetColsSymbolsExclPartition, out);
        }
        if (this.targetColsExclPartitionCols == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.targetColsExclPartitionCols.size());
            for (Reference reference : this.targetColsExclPartitionCols) {
                Reference.toStream(reference, out);
            }
        }
        out.writeBoolean(this.ignoreDuplicateKeys);
        if (this.onDuplicateKeyAssignments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.onDuplicateKeyAssignments.size());
            for (Map.Entry entry : this.onDuplicateKeyAssignments.entrySet()) {
                Reference.toStream((Reference)entry.getKey(), out);
                Symbols.toStream((Symbol)entry.getValue(), out);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeVInt(this.allTargetColumns.size());
            for (Reference reference : this.allTargetColumns) {
                Symbols.toStream(reference, out);
            }
            if (this.outputs != null) {
                out.writeVInt(this.outputs.size());
                for (Symbol symbol : this.outputs) {
                    Symbols.toStream(symbol, out);
                }
            } else {
                out.writeVInt(0);
            }
            out.writeVInt(this.returnValues.size());
            for (Symbol symbol : this.returnValues) {
                Symbols.toStream(symbol, out);
            }
        }
    }

    public ColumnIndexWriterProjection bind(Function<? super Symbol, Symbol> binder) {
        HashMap<Reference, Symbol> boundOnDuplicateKeyAssignments = new HashMap<Reference, Symbol>(this.onDuplicateKeyAssignments.size());
        for (Map.Entry<Reference, Symbol> assignment : this.onDuplicateKeyAssignments.entrySet()) {
            boundOnDuplicateKeyAssignments.put(assignment.getKey(), binder.apply(assignment.getValue()));
        }
        return new ColumnIndexWriterProjection(this.tableIdent(), null, this.primaryKeys, this.allTargetColumns, this.targetColsExclPartitionCols, this.targetColsSymbolsExclPartition, this.ignoreDuplicateKeys, boundOnDuplicateKeyAssignments, this.ids(), this.partitionedBySymbols, this.clusteredByIdent(), this.clusteredBySymbol, Settings.EMPTY, this.autoCreateIndices(), this.outputs, this.returnValues);
    }
}

