/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.Lists2;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AggregationProjection
extends Projection {
    private final RowGranularity contextGranularity;
    private final AggregateMode mode;
    private final List<Aggregation> aggregations;

    public AggregationProjection(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.aggregations = new ArrayList<Aggregation>(size);
        for (int i = 0; i < size; ++i) {
            this.aggregations.add((Aggregation)Symbols.fromStream(in));
        }
        this.contextGranularity = RowGranularity.fromStream(in);
        this.mode = AggregateMode.readFrom(in);
    }

    public AggregationProjection(List<Aggregation> aggregations, RowGranularity contextGranularity, AggregateMode mode) {
        assert (aggregations != null) : "aggregations must not be null";
        assert (aggregations.stream().noneMatch(s -> SymbolVisitors.any(Symbols.IS_COLUMN.or(x -> x instanceof SelectSymbol), s))) : "Cannot operate on Reference, Field or SelectSymbol symbols: " + aggregations;
        this.contextGranularity = contextGranularity;
        this.mode = mode;
        this.aggregations = aggregations;
    }

    @Override
    public RowGranularity requiredGranularity() {
        return this.contextGranularity;
    }

    public List<Aggregation> aggregations() {
        return this.aggregations;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.AGGREGATION;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitAggregationProjection(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.aggregations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbols.toStream(this.aggregations, out);
        RowGranularity.toStream(this.contextGranularity, out);
        AggregateMode.writeTo(this.mode, out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationProjection that = (AggregationProjection)o;
        return this.contextGranularity == that.contextGranularity && this.mode == that.mode && Objects.equals(this.aggregations, that.aggregations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.contextGranularity, this.mode, this.aggregations});
    }

    public AggregateMode mode() {
        return this.mode;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put("type", "HashAggregation").put("aggregations", "[" + Lists2.joinOn(", ", this.aggregations, Symbol::toString) + "]").map();
    }
}

