/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public abstract class AbstractIndexWriterProjection
extends Projection {
    public static final List<? extends Symbol> OUTPUTS = List.of(new InputColumn(0, DataTypes.LONG));
    private static final String BULK_SIZE = "bulk_size";
    @VisibleForTesting
    public static final int BULK_SIZE_DEFAULT = 10000;
    private final int bulkActions;
    protected RelationName relationName;
    protected String partitionIdent;
    protected List<ColumnIdent> primaryKeys;
    @Nullable
    private ColumnIdent clusteredByColumn;
    private List<Symbol> idSymbols;
    List<Symbol> partitionedBySymbols;
    @Nullable
    Symbol clusteredBySymbol;
    private boolean autoCreateIndices;

    protected AbstractIndexWriterProjection(RelationName relationName, @Nullable String partitionIdent, List<ColumnIdent> primaryKeys, @Nullable ColumnIdent clusteredByColumn, Settings settings, List<Symbol> idSymbols, boolean autoCreateIndices) {
        this.relationName = relationName;
        this.partitionIdent = partitionIdent;
        this.primaryKeys = primaryKeys;
        this.clusteredByColumn = clusteredByColumn;
        this.autoCreateIndices = autoCreateIndices;
        this.idSymbols = idSymbols;
        this.bulkActions = settings.getAsInt(BULK_SIZE, 10000);
        if (this.bulkActions <= 0) {
            throw new IllegalArgumentException("\"bulk_size\" must be greater than 0.");
        }
    }

    protected AbstractIndexWriterProjection(StreamInput in) throws IOException {
        this.relationName = new RelationName(in);
        this.partitionIdent = in.readOptionalString();
        this.idSymbols = Symbols.listFromStream(in);
        int numPks = in.readVInt();
        this.primaryKeys = new ArrayList<ColumnIdent>(numPks);
        for (int i = 0; i < numPks; ++i) {
            this.primaryKeys.add(new ColumnIdent(in));
        }
        this.partitionedBySymbols = Symbols.listFromStream(in);
        this.clusteredBySymbol = in.readBoolean() ? Symbols.fromStream(in) : null;
        if (in.readBoolean()) {
            this.clusteredByColumn = new ColumnIdent(in);
        }
        this.bulkActions = in.readVInt();
        this.autoCreateIndices = in.readBoolean();
    }

    public List<? extends Symbol> ids() {
        return this.idSymbols;
    }

    @Nullable
    public ColumnIdent clusteredByIdent() {
        return this.clusteredByColumn;
    }

    @Nullable
    public Symbol clusteredBy() {
        return this.clusteredBySymbol;
    }

    public List<Symbol> partitionedBySymbols() {
        return this.partitionedBySymbols;
    }

    public boolean autoCreateIndices() {
        return this.autoCreateIndices;
    }

    public List<ColumnIdent> primaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public List<? extends Symbol> outputs() {
        return OUTPUTS;
    }

    public int bulkActions() {
        return this.bulkActions;
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    @Nullable
    public String partitionIdent() {
        return this.partitionIdent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractIndexWriterProjection)) {
            return false;
        }
        AbstractIndexWriterProjection that = (AbstractIndexWriterProjection)o;
        if (this.autoCreateIndices != that.autoCreateIndices) {
            return false;
        }
        if (this.bulkActions != that.bulkActions) {
            return false;
        }
        if (this.clusteredByColumn != null ? !this.clusteredByColumn.equals(that.clusteredByColumn) : that.clusteredByColumn != null) {
            return false;
        }
        if (this.clusteredBySymbol != null ? !this.clusteredBySymbol.equals(that.clusteredBySymbol) : that.clusteredBySymbol != null) {
            return false;
        }
        if (!this.idSymbols.equals(that.idSymbols)) {
            return false;
        }
        if (!this.partitionedBySymbols.equals(that.partitionedBySymbols)) {
            return false;
        }
        if (!this.primaryKeys.equals(that.primaryKeys)) {
            return false;
        }
        if (!this.relationName.equals(that.relationName)) {
            return false;
        }
        return !(this.partitionIdent != null ? !this.partitionIdent.equals(that.partitionIdent) : that.partitionIdent != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Integer.hashCode(this.bulkActions);
        result = 31 * result + this.relationName.hashCode();
        result = 31 * result + (this.partitionIdent != null ? this.partitionIdent.hashCode() : 0);
        result = 31 * result + this.primaryKeys.hashCode();
        result = 31 * result + (this.clusteredByColumn != null ? this.clusteredByColumn.hashCode() : 0);
        result = 31 * result + this.idSymbols.hashCode();
        result = 31 * result + this.partitionedBySymbols.hashCode();
        result = 31 * result + (this.clusteredBySymbol != null ? this.clusteredBySymbol.hashCode() : 0);
        result = 31 * result + (this.autoCreateIndices ? 1 : 0);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.relationName.writeTo(out);
        out.writeOptionalString(this.partitionIdent);
        Symbols.toStream(this.idSymbols, out);
        out.writeVInt(this.primaryKeys.size());
        for (ColumnIdent primaryKey : this.primaryKeys) {
            primaryKey.writeTo(out);
        }
        Symbols.toStream(this.partitionedBySymbols, out);
        if (this.clusteredBySymbol == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Symbols.toStream(this.clusteredBySymbol, out);
        }
        if (this.clusteredByColumn == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.clusteredByColumn.writeTo(out);
        }
        out.writeVInt(this.bulkActions);
        out.writeBoolean(this.autoCreateIndices);
    }
}

