/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitors;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.PKAndVersion;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public final class PKLookupPhase
extends AbstractProjectionsPhase
implements CollectPhase {
    private final List<ColumnIdent> partitionedByColumns;
    private final List<Symbol> toCollect;
    private final Map<String, Map<ShardId, List<PKAndVersion>>> idsByShardByNode;
    private DistributionInfo distInfo = DistributionInfo.DEFAULT_BROADCAST;

    public PKLookupPhase(UUID jobId, int phaseId, List<ColumnIdent> partitionedByColumns, List<Symbol> toCollect, Map<String, Map<ShardId, List<PKAndVersion>>> idsByShardByNode) {
        super(jobId, phaseId, "pkLookup", Collections.emptyList());
        assert (toCollect.stream().noneMatch(st -> SymbolVisitors.any(s -> s instanceof ScopedSymbol || s instanceof SelectSymbol, st))) : "toCollect must not contain any fields or selectSymbols: " + toCollect;
        this.partitionedByColumns = partitionedByColumns;
        this.toCollect = toCollect;
        this.idsByShardByNode = idsByShardByNode;
    }

    public PKLookupPhase(StreamInput in) throws IOException {
        super(in);
        this.distInfo = new DistributionInfo(in);
        this.toCollect = Symbols.listFromStream(in);
        int numNodes = in.readVInt();
        this.idsByShardByNode = new HashMap<String, Map<ShardId, List<PKAndVersion>>>(numNodes);
        for (int nodeIdx = 0; nodeIdx < numNodes; ++nodeIdx) {
            String nodeId = in.readString();
            int numShards = in.readVInt();
            HashMap idsByShard = new HashMap(numShards);
            this.idsByShardByNode.put(nodeId, idsByShard);
            for (int shardIdx = 0; shardIdx < numShards; ++shardIdx) {
                ShardId shardId = new ShardId(in);
                int numPks = in.readVInt();
                ArrayList<PKAndVersion> pks = new ArrayList<PKAndVersion>(numPks);
                for (int pkIdx = 0; pkIdx < numPks; ++pkIdx) {
                    pks.add(new PKAndVersion(in));
                }
                idsByShard.put(shardId, pks);
            }
        }
        int numPartitionedByCols = in.readVInt();
        if (numPartitionedByCols == 0) {
            this.partitionedByColumns = Collections.emptyList();
        } else {
            this.partitionedByColumns = new ArrayList<ColumnIdent>(numPartitionedByCols);
            for (int i = 0; i < numPartitionedByCols; ++i) {
                this.partitionedByColumns.add(new ColumnIdent(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.distInfo.writeTo(out);
        Symbols.toStream(this.toCollect, out);
        out.writeVInt(this.idsByShardByNode.size());
        for (Map.Entry<String, Map<ShardId, List<PKAndVersion>>> byNodeEntry : this.idsByShardByNode.entrySet()) {
            Map<ShardId, List<PKAndVersion>> idsByShard = byNodeEntry.getValue();
            out.writeString(byNodeEntry.getKey());
            out.writeVInt(idsByShard.size());
            for (Map.Entry<ShardId, List<PKAndVersion>> shardEntry : idsByShard.entrySet()) {
                List<PKAndVersion> ids = shardEntry.getValue();
                shardEntry.getKey().writeTo(out);
                out.writeVInt(ids.size());
                for (PKAndVersion id : ids) {
                    id.writeTo(out);
                }
            }
        }
        out.writeVInt(this.partitionedByColumns.size());
        for (ColumnIdent partitionedByColumn : this.partitionedByColumns) {
            partitionedByColumn.writeTo(out);
        }
    }

    @Override
    public List<DataType<?>> outputTypes() {
        if (this.projections.isEmpty()) {
            return Symbols.typeView(this.toCollect);
        }
        return super.outputTypes();
    }

    @Override
    public List<Symbol> toCollect() {
        return this.toCollect;
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distInfo = distributionInfo;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.PKLookup;
    }

    @Override
    public Collection<String> nodeIds() {
        return this.idsByShardByNode.keySet();
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitPKLookup(this, context);
    }

    public Map<ShardId, List<PKAndVersion>> getIdsByShardId(String nodeId) {
        return this.idsByShardByNode.getOrDefault(nodeId, Collections.emptyMap());
    }

    public List<ColumnIdent> partitionedByColumns() {
        return this.partitionedByColumns;
    }
}

